/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.lang.reflect.Field;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.apache.catalina.websocket.WsHttpServletRequestWrapper;
import org.granite.context.GraniteContext;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.GravityManager;
import org.granite.gravity.GravityServletUtil;
import org.granite.gravity.tomcat.TomcatWebSocketChannel;
import org.granite.gravity.tomcat.TomcatWebSocketChannelFactory;
import org.granite.gravity.websocket.WebSocketUtil;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public class TomcatWebSocketServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TomcatWebSocketServlet.class);
    private static Field requestField = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        GravityServletUtil.init(config);
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        for (String protocol : subProtocols) {
            if (!protocol.startsWith("org.granite.gravity")) continue;
            return protocol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamInbound createWebSocketInbound(String protocol, HttpServletRequest request) {
        GravityInternal gravity = (GravityInternal)((Object)GravityManager.getGravity(this.getServletContext()));
        TomcatWebSocketChannelFactory channelFactory = new TomcatWebSocketChannelFactory(gravity);
        try {
            String connectMessageId = TomcatWebSocketServlet.getHeaderOrParameter(request, "connectId");
            String clientId = TomcatWebSocketServlet.getHeaderOrParameter(request, "GDSClientId");
            String clientType = TomcatWebSocketServlet.getHeaderOrParameter(request, "GDSClientType");
            String sessionId = null;
            HttpSession session = request.getSession(false);
            if (session != null) {
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.getServletContext(), session, clientType);
                sessionId = session.getId();
            } else if (request.getCookies() != null) {
                for (int i = 0; i < request.getCookies().length; ++i) {
                    if (!"JSESSIONID".equals(request.getCookies()[i].getName())) continue;
                    sessionId = request.getCookies()[i].getValue();
                    break;
                }
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.getServletContext(), sessionId, clientType);
            } else {
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.getServletContext(), (String)null, clientType);
            }
            log.info("WebSocket connection started %s clientId %s sessionId %s", protocol, clientId, sessionId);
            CommandMessage pingMessage = new CommandMessage();
            pingMessage.setMessageId(connectMessageId != null ? connectMessageId : "OPEN_CONNECTION");
            pingMessage.setOperation(5);
            if (clientId != null) {
                pingMessage.setClientId(clientId);
            }
            Message ackMessage = gravity.handleMessage(channelFactory, pingMessage);
            if (sessionId != null) {
                ackMessage.setHeader("JSESSIONID", sessionId);
            }
            TomcatWebSocketChannel channel = gravity.getChannel(channelFactory, (String)ackMessage.getClientId());
            channel.setSession(session);
            if (gravity.getGraniteConfig().getSecurityService() != null) {
                try {
                    gravity.getGraniteConfig().getSecurityService().prelogin(session, request instanceof WsHttpServletRequestWrapper ? requestField.get(request) : request, this.getServletConfig().getServletName());
                }
                catch (IllegalAccessException e) {
                    log.warn(e, "Could not get internal request object", new Object[0]);
                }
            }
            String ctype = request.getContentType();
            ContentType contentType = WebSocketUtil.getContentType(ctype, protocol);
            channel.setContentType(contentType);
            if (!ackMessage.getClientId().equals(clientId)) {
                channel.setConnectAckMessage(ackMessage);
            }
            StreamInbound streamInbound = channel.getStreamInbound();
            return streamInbound;
        }
        finally {
            GraniteContext.release();
        }
    }

    private static String getHeaderOrParameter(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (value == null) {
            value = request.getParameter(key);
        }
        return value;
    }

    static {
        try {
            requestField = WsHttpServletRequestWrapper.class.getDeclaredField("request");
            requestField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

