/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.websocket;

import java.util.List;
import javax.servlet.http.HttpSession;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.granite.gravity.Gravity;
import org.granite.gravity.websocket.GravityWebSocketConfig;
import org.granite.gravity.websocket.WebSocketUtil;
import org.granite.logging.Logger;
import org.granite.util.ContentType;

public class GravityWebSocketConfigurator
extends ServerEndpointConfig.Configurator {
    private static final Logger log = Logger.getLogger(GravityWebSocketConfigurator.class);

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        for (String p : requested) {
            if (!supported.contains(p)) continue;
            return p;
        }
        return null;
    }

    public void modifyHandshake(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
        String connectMessageId = GravityWebSocketConfigurator.getHeaderOrParameter(request, "connectId", true);
        String clientId = GravityWebSocketConfigurator.getHeaderOrParameter(request, "GDSClientId", true);
        String clientType = GravityWebSocketConfigurator.getHeaderOrParameter(request, "GDSClientType", true);
        HttpSession session = (HttpSession)request.getHttpSession();
        log.debug("WebSocket configurator handshake ackId %s clientId %s sessionId %s", connectMessageId, clientId, session != null ? session.getId() : "(none)");
        Gravity gravity = (Gravity)config.getUserProperties().get("gravity");
        if (gravity.getGraniteConfig().getSecurityService() != null) {
            gravity.getGraniteConfig().getSecurityService().prelogin(session, request, null);
        }
        String ctype = GravityWebSocketConfigurator.getHeader(request, "Content-Type", true);
        String protocol = GravityWebSocketConfigurator.getHeader(request, "Sec-WebSocket-Protocol", true);
        ContentType contentType = WebSocketUtil.getContentType(ctype, protocol);
        GravityWebSocketConfig.set(connectMessageId, clientId, clientType, contentType, session);
    }

    private static String getHeader(HandshakeRequest request, String key, boolean lower) {
        List values = (List)request.getHeaders().get(key);
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        if (lower && (values = (List)request.getHeaders().get(key.toLowerCase())) != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    private static String getParameter(HandshakeRequest request, String key) {
        List values = (List)request.getParameterMap().get(key);
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    private static String getHeaderOrParameter(HandshakeRequest request, String key, boolean lower) {
        String value = GravityWebSocketConfigurator.getHeader(request, key, lower);
        if (value == null) {
            value = GravityWebSocketConfigurator.getParameter(request, key);
        }
        return value;
    }
}

