/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.websocket;

import java.util.Arrays;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.gravity.websocket.GravityWebSocketConfigurator;
import org.granite.gravity.websocket.GravityWebSocketEndpoint;

public class GravityWebSocketDeployer
implements ServletContextListener {
    private static final String WEBSOCKET_DEPLOYED_ATTR = GravityWebSocketDeployer.class.getName() + "_deployed";

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServerContainer serverContainer = (ServerContainer)servletContextEvent.getServletContext().getAttribute(ServerContainer.class.getName());
        if (serverContainer == null) {
            return;
        }
        Object deployed = servletContextEvent.getServletContext().getAttribute(WEBSOCKET_DEPLOYED_ATTR);
        if (deployed != null) {
            return;
        }
        Gravity gravity = GravityManager.getGravity(servletContextEvent.getServletContext());
        try {
            if (gravity == null) {
                gravity = GravityManager.start(servletContextEvent.getServletContext());
            }
            try {
                serverContainer.setDefaultMaxSessionIdleTimeout(gravity.getGravityConfig().getChannelIdleTimeoutMillis());
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            ServerEndpointConfig serverEndpointConfig = ServerEndpointConfig.Builder.create(GravityWebSocketEndpoint.class, (String)"/websocketamf/amf").configurator((ServerEndpointConfig.Configurator)new GravityWebSocketConfigurator()).subprotocols(Arrays.asList("org.granite.gravity", "org.granite.gravity.amf", "org.granite.gravity.jmf+amf")).build();
            serverEndpointConfig.getUserProperties().put("servletContext", servletContextEvent.getServletContext());
            serverEndpointConfig.getUserProperties().put("gravity", gravity);
            serverContainer.addEndpoint(serverEndpointConfig);
            servletContextEvent.getServletContext().setAttribute(WEBSOCKET_DEPLOYED_ATTR, (Object)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deploy gravity websocket endpoint", e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

