/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.websocket;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.granite.context.GraniteContext;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.websocket.GravityWebSocketConfig;
import org.granite.gravity.websocket.WebSocketChannel;
import org.granite.gravity.websocket.WebSocketChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public class GravityWebSocketEndpoint
extends Endpoint {
    private static final Logger log = Logger.getLogger(GravityWebSocketEndpoint.class);
    private final GravityWebSocketConfig config = GravityWebSocketConfig.remove();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        GravityInternal gravity = (GravityInternal)endpointConfig.getUserProperties().get("gravity");
        ServletContext servletContext = (ServletContext)endpointConfig.getUserProperties().get("servletContext");
        String connectMessageId = this.config.connectMessageId;
        String clientId = this.config.clientId;
        String clientType = this.config.clientType;
        ContentType contentType = this.config.contentType;
        HttpSession httpSession = this.config.session;
        try {
            String sessionId = null;
            if (httpSession != null) {
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), servletContext, httpSession, clientType);
                sessionId = httpSession.getId();
            } else {
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), servletContext, (String)null, clientType);
            }
            CommandMessage pingMessage = new CommandMessage();
            pingMessage.setMessageId(connectMessageId != null ? connectMessageId : "OPEN_CONNECTION");
            pingMessage.setOperation(5);
            if (clientId != null) {
                pingMessage.setClientId(clientId);
            }
            WebSocketChannelFactory channelFactory = new WebSocketChannelFactory(gravity);
            Message ackMessage = gravity.handleMessage(channelFactory, pingMessage);
            if (sessionId != null) {
                ackMessage.setHeader("JSESSIONID", sessionId);
            }
            log.info("WebSocket connection started connectId %s clientId %s ackClientId %s sessionId %s", pingMessage.getMessageId(), clientId, ackMessage.getClientId(), sessionId);
            WebSocketChannel channel = gravity.getChannel(channelFactory, (String)ackMessage.getClientId());
            channel.setSession(httpSession);
            channel.setContentType(contentType);
            channel.setConnectAckMessage(ackMessage);
            session.getUserProperties().put("channel", channel);
            session.setMaxIdleTimeout(channel.getGravity().getGravityConfig().getChannelIdleTimeoutMillis());
            channel.onWebSocketConnect(session);
        }
        finally {
            GraniteContext.release();
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        WebSocketChannel channel = (WebSocketChannel)session.getUserProperties().get("channel");
        channel.onWebSocketClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }

    public void onError(Session session, Throwable error) {
        try {
            WebSocketChannel channel = (WebSocketChannel)session.getUserProperties().get("channel");
            if (channel != null) {
                channel.onWebSocketError(error);
            } else {
                log.error(error, "WebSocket error for session %s", session.getId());
            }
        }
        catch (Exception e) {
            log.error(error, "WebSocket error for session %s", session.getId());
        }
    }
}

