/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.granite.logging.Logger;

public class PolicyFileServer
implements Runnable {
    private static final Logger log = Logger.getLogger(PolicyFileServer.class);
    private int serverPort = 843;
    private String[] allowDomains = new String[0];
    private String[] allowPorts = new String[0];
    private Thread policyServer = null;

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setAllowDomains(String[] domains) {
        this.allowDomains = domains;
    }

    public void setAllowPorts(String[] ports) {
        this.allowPorts = ports;
    }

    public void start() {
        this.policyServer = new Thread((Runnable)this, "FlashPolicyFileServer:" + this.serverPort);
        this.policyServer.start();
    }

    public void stop() {
        if (this.policyServer != null) {
            this.policyServer.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocketChannel server = null;
        try {
            server = ServerSocketChannel.open();
            server.socket().bind(new InetSocketAddress(this.serverPort));
            log.info("Flash socket policy server started on port " + this.serverPort, new Object[0]);
        }
        catch (IOException e) {
            log.error(e, "Could not init flash socket policy server on port " + this.serverPort, new Object[0]);
            return;
        }
        while (true) {
            SocketChannel socket = null;
            try {
                ByteBuffer buf;
                socket = server.accept();
                int size = socket.read(buf = ByteBuffer.allocate(100));
                if (size != 23) continue;
                byte[] req = new byte[size];
                buf.get(req, 0, size);
                String request = new String(req, "UTF-8");
                log.info("Received policy file request %s", request);
                String policyFile = "<?xml version=\"1.0\"?>\n<!DOCTYPE cross-domain-policy SYSTEM \"http://www.macromedia.com/xml/dtds/cross-domain-policy.dtd\"><cross-domain-policy>";
                for (int i = 0; i < this.allowDomains.length; ++i) {
                    policyFile = policyFile + "  <allow-access-from domain=\"" + this.allowDomains[i] + "\" to-ports=\"" + this.allowPorts[i] + "\"/>";
                }
                policyFile = policyFile + "</cross-domain-policy>";
                byte[] bytes = policyFile.getBytes("UTF-8");
                socket.write(ByteBuffer.wrap(bytes));
                continue;
            }
            catch (ClosedByInterruptException e) {
                log.info("Flash socket policy server stopped", new Object[0]);
            }
            catch (IOException e) {
                log.error(e, "Could not send policy file", new Object[0]);
                continue;
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException e) {
                    log.error(e, "Could not close socket", new Object[0]);
                }
                continue;
            }
            break;
        }
    }
}

