/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.websocket.AbstractWebSocketChannel;
import org.granite.gravity.websocket.WebSocketChannelFactory;
import org.granite.logging.Logger;

public class WebSocketChannel
extends AbstractWebSocketChannel
implements MessageHandler.Whole<byte[]> {
    private static final Logger log = Logger.getLogger(WebSocketChannel.class);
    private Session session;

    public WebSocketChannel(GravityInternal gravity, String id, WebSocketChannelFactory factory, String clientType) {
        super(gravity, id, factory, clientType);
        log.debug("Create channel %s", this.getId());
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        this.setMaxBinaryMessageBufferSize(session.getMaxBinaryMessageBufferSize());
        this.connect();
        session.addMessageHandler((MessageHandler)this);
        this.gravity.notifyConnected(this);
    }

    public void onWebSocketClose(int closeCode, String message) {
        log.debug("Channel %s websocket connection onClose %d, %s", this.getId(), closeCode, message);
        this.session = null;
        this.gravity.notifyDisconnected(this);
    }

    public void onWebSocketError(Throwable throwable) {
        log.error(throwable, "Channel %s websocket error", new Object[0]);
    }

    public void onMessage(byte[] data) {
        this.receiveBytes(data, 0, data.length);
    }

    @Override
    public boolean isConnected() {
        log.debug("Channel %s websocket connection %s", this.getId(), this.session == null ? "(null)" : (this.session.isOpen() ? "(open)" : "(not open)"));
        return this.session != null && this.session.isOpen();
    }

    @Override
    protected void sendBytes(byte[] msg) throws IOException {
        if (this.session != null && this.session.isOpen()) {
            if (msg.length <= this.getMaxBinaryMessageBufferSize()) {
                this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(msg));
            } else {
                int length = this.getMaxBinaryMessageBufferSize();
                int offset = 0;
                do {
                    this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(msg, offset, length), false);
                } while (msg.length - (offset += length) > length);
                this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(msg, offset, msg.length - offset), true);
            }
        }
    }

    @Override
    public void close() {
        log.debug("Channel %s close", this.getId());
        if (this.session != null) {
            try {
                this.session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Channel closed"));
            }
            catch (IOException e) {
                throw new RuntimeException("Channel close error " + this.getId(), e);
            }
            this.session = null;
            this.gravity.notifyDisconnected(this);
        }
    }
}

