/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.websocket;

import org.granite.logging.Logger;
import org.granite.util.ContentType;

public class WebSocketUtil {
    private static final Logger log = Logger.getLogger(WebSocketUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentType getContentType(String contentType, String protocol) {
        ContentType type;
        if (contentType == null) {
            if (protocol != null) {
                if ("org.granite.gravity".equals(protocol)) {
                    contentType = ContentType.AMF.mimeType();
                } else {
                    if (!protocol.startsWith("org.granite.gravity.")) throw new RuntimeException("Missing Content-Type and unsupported Sec-WebSocket-Protocol: " + protocol);
                    contentType = "application/x-" + protocol.substring("org.granite.gravity.".length());
                }
            } else {
                contentType = ContentType.AMF.mimeType();
                log.warn("Missing Content-Type and Sec-WebSocket-Protocol in handshake request. Using: %s", contentType);
            }
        }
        if ((type = ContentType.forMimeType(contentType)) != null) return type;
        log.warn("No (or unsupported) content type in handshake request: %s. Using: %s", contentType, ContentType.AMF.mimeType());
        return ContentType.AMF;
    }
}

