/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io;

import flex.messaging.io.ASObject;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.granite.config.AMF3Config;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF0Body;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.io.AMF3Deserializer;
import org.w3c.dom.Document;

public class AMF0Deserializer {
    private static final Logger log = Logger.getLogger(AMF0Deserializer.class);
    private List<Object> storedObjects = null;
    private final DataInput dataInput;
    private final AMF0Message message = new AMF0Message();

    public AMF0Deserializer(InputStream inputStream) throws IOException {
        AMF3Config config = (AMF3Config)GraniteContext.getCurrentInstance().getGraniteConfig();
        this.dataInput = config.newAMF3Deserializer(inputStream);
        this.readHeaders();
        log.debug("readHeader", new Object[0]);
        this.readBodies();
        log.debug("readBody", new Object[0]);
    }

    public AMF0Message getAMFMessage() {
        return this.message;
    }

    protected void readHeaders() throws IOException {
        this.message.setVersion(this.dataInput.readUnsignedShort());
        int headerCount = this.dataInput.readUnsignedShort();
        log.debug("headerCount = %d", headerCount);
        for (int i = 0; i < headerCount; ++i) {
            this.storedObjects = new ArrayList<Object>();
            String key = this.dataInput.readUTF();
            boolean required = this.dataInput.readBoolean();
            this.dataInput.readInt();
            byte type = this.dataInput.readByte();
            Object value = this.readData(type);
            this.message.addHeader(key, required, value);
        }
    }

    protected void readBodies() throws IOException {
        int bodyCount = this.dataInput.readUnsignedShort();
        log.debug("bodyCount = %d", bodyCount);
        for (int i = 0; i < bodyCount; ++i) {
            this.storedObjects = new ArrayList<Object>();
            String method = this.dataInput.readUTF();
            String target = this.dataInput.readUTF();
            this.dataInput.readInt();
            byte type = this.dataInput.readByte();
            log.debug("type = 0x%02X", type);
            Object data = this.readData(type);
            this.message.addBody(method, target, data, type);
        }
    }

    protected Object readCustomClass() throws IOException {
        String type = this.dataInput.readUTF();
        log.debug("Reading Custom Class: %s", type);
        ASObject aso = new ASObject(type);
        return this.readObject(aso);
    }

    protected ASObject readObject() throws IOException {
        ASObject aso = new ASObject();
        return this.readObject(aso);
    }

    protected ASObject readObject(ASObject aso) throws IOException {
        this.storeObject(aso);
        log.debug("reading object", new Object[0]);
        String key = this.dataInput.readUTF();
        byte type = this.dataInput.readByte();
        while (type != 9) {
            Object value = this.readData(type);
            if (value == null) {
                log.info("Skipping NULL value for : %s", key);
            } else {
                aso.put(key, value);
                log.debug(" adding {key=%s, value=%s, type=%d}", key, value, type);
            }
            key = this.dataInput.readUTF();
            type = this.dataInput.readByte();
        }
        log.debug("finished reading object", new Object[0]);
        return aso;
    }

    protected List<?> readArray() throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        this.storeObject(array);
        log.debug("Reading array", new Object[0]);
        long length = this.dataInput.readInt();
        log.debug("array length = %d", length);
        for (long i = 0L; i < length; ++i) {
            byte type = this.dataInput.readByte();
            Object data = this.readData(type);
            array.add(data);
        }
        return array;
    }

    private void storeObject(Object o) {
        this.storedObjects.add(o);
        log.debug("storedObjects.size: %d", this.storedObjects.size());
    }

    protected Date readDate() throws IOException {
        long ms = (long)this.dataInput.readDouble();
        int timeoffset = this.dataInput.readShort() * 60000 * -1;
        TimeZone serverTimeZone = TimeZone.getDefault();
        GregorianCalendar sent = new GregorianCalendar();
        sent.setTime(new Date(ms - (long)serverTimeZone.getRawOffset() + (long)timeoffset));
        TimeZone sentTimeZone = ((Calendar)sent).getTimeZone();
        if (sentTimeZone.inDaylightTime(sent.getTime())) {
            sent.setTime(new Date(sent.getTime().getTime() - 3600000L));
        }
        return sent.getTime();
    }

    protected Object readFlushedSO() throws IOException {
        int index = this.dataInput.readUnsignedShort();
        log.debug("Object Index: %d", index);
        return this.storedObjects.get(index);
    }

    protected Object readASObject() {
        return null;
    }

    protected Object readAMF3Data() throws IOException {
        AMF3Deserializer amf3 = (AMF3Deserializer)this.dataInput;
        amf3.reset();
        return amf3.readObject();
    }

    protected Object readData(byte type) throws IOException {
        log.debug("Reading data of type: %s", AMF0Body.getObjectTypeDescription(type));
        switch (type) {
            case 0: {
                return new Double(this.dataInput.readDouble());
            }
            case 1: {
                return new Boolean(this.dataInput.readBoolean());
            }
            case 2: {
                return this.dataInput.readUTF();
            }
            case 3: {
                return this.readObject();
            }
            case 4: {
                throw new IOException("Unknown/unsupported object type " + AMF0Body.getObjectTypeDescription(type));
            }
            case 5: 
            case 6: {
                return null;
            }
            case 7: {
                return this.readFlushedSO();
            }
            case 8: {
                this.dataInput.readInt();
                return this.readObject();
            }
            case 9: {
                return null;
            }
            case 10: {
                return this.readArray();
            }
            case 11: {
                return this.readDate();
            }
            case 12: {
                return this.readLongUTF(this.dataInput);
            }
            case 13: {
                return this.readASObject();
            }
            case 14: {
                return null;
            }
            case 15: {
                return AMF0Deserializer.convertToDOM(this.dataInput);
            }
            case 16: {
                return this.readCustomClass();
            }
            case 17: {
                return this.readAMF3Data();
            }
        }
        throw new IOException("Unknown/unsupported object type " + AMF0Body.getObjectTypeDescription(type));
    }

    private Object readLongUTF(DataInput in) throws IOException {
        int utflen = in.readInt();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        in.readFully(bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }

    public static Document convertToDOM(DataInput is) throws IOException {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        int length = is.readInt();
        try {
            byte[] buf = new byte[length];
            is.readFully(buf, 0, length);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new ByteArrayInputStream(buf));
        }
        catch (Exception e) {
            throw new IOException("Error while parsing xml: " + e.getMessage());
        }
        return document;
    }
}

