/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.NoConverterFoundException;
import org.granite.messaging.amf.io.convert.Reverter;
import org.granite.util.TypeUtil;

public class Converters {
    private Converter[] converters;
    private Reverter[] reverters;

    public Converters(List<Class<? extends Converter>> converterClasses) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        ArrayList<Reverter> reverters = new ArrayList<Reverter>();
        if (converterClasses != null) {
            for (Class<? extends Converter> converterClass : converterClasses) {
                Constructor<? extends Converter> constructor = converterClass.getConstructor(Converters.class);
                Converter converter = constructor.newInstance(this);
                converters.add(converter);
                if (!(converter instanceof Reverter)) continue;
                reverters.add((Reverter)((Object)converter));
            }
        }
        this.converters = converters.toArray(new Converter[converters.size()]);
        this.reverters = reverters.toArray(new Reverter[reverters.size()]);
    }

    public void addConverter(Class<? extends Converter> converterClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Converter[] converters = new Converter[this.converters.length + 1];
        System.arraycopy(this.converters, 0, converters, 1, this.converters.length);
        Constructor<? extends Converter> constructor = converterClass.getConstructor(Converters.class);
        converters[0] = constructor.newInstance(this);
        this.converters = converters;
        if (converters[0] instanceof Reverter) {
            Reverter[] reverters = new Reverter[this.reverters.length + 1];
            System.arraycopy(this.reverters, 0, reverters, 1, this.reverters.length);
            reverters[0] = (Reverter)((Object)converters[0]);
            this.reverters = reverters;
        }
    }

    public Converter getConverter(Object value, Type targetType) {
        return this.getConverter(value, targetType, false);
    }

    public Converter getConverter(Object value, Type targetType, boolean throwNotFoundException) throws NoConverterFoundException {
        if (targetType instanceof TypeVariable) {
            targetType = TypeUtil.getBoundType((TypeVariable)targetType);
        }
        for (Converter converter : this.converters) {
            if (!converter.canConvert(value, targetType)) continue;
            return converter;
        }
        if (!throwNotFoundException) {
            return null;
        }
        throw new NoConverterFoundException(value, targetType);
    }

    public Object convert(Object value, Type targetType) throws NoConverterFoundException {
        if (value != null) {
            Class targetClass;
            Class<?> valueClass = value.getClass();
            if (valueClass == targetType) {
                return value;
            }
            if (targetType instanceof Class && (targetClass = (Class)targetType).isPrimitive()) {
                if (targetClass == Integer.TYPE && valueClass == Integer.class) {
                    return value;
                }
                if (targetClass == Boolean.TYPE && valueClass == Boolean.class) {
                    return value;
                }
                if (targetClass == Double.TYPE && valueClass == Double.class) {
                    return value;
                }
                if (targetClass == Long.TYPE && valueClass == Long.class) {
                    return value;
                }
                if (targetClass == Byte.TYPE && valueClass == Byte.class) {
                    return value;
                }
                if (targetClass == Character.TYPE && valueClass == Character.class) {
                    return value;
                }
                if (targetClass == Float.TYPE && valueClass == Float.class) {
                    return value;
                }
                if (targetClass == Short.TYPE && valueClass == Short.class) {
                    return value;
                }
            }
        } else if (targetType instanceof Class && !((Class)targetType).isPrimitive()) {
            return value;
        }
        return this.getConverter(value, targetType, true).convert(value, targetType);
    }

    public boolean hasReverters() {
        return this.reverters.length > 0;
    }

    public Object revert(Object value) {
        for (Reverter reverter : this.reverters) {
            if (!reverter.canRevert(value)) continue;
            return reverter.revert(value);
        }
        return value;
    }

    public Converter[] getConverters() {
        Converter[] copy = new Converter[this.converters.length];
        System.arraycopy(this.converters, 0, copy, 0, this.converters.length);
        return copy;
    }
}

