/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.types.AMFSpecialValueFactory;
import org.granite.util.TypeUtil;

public class MethodProperty
extends Property {
    private final Method setter;
    private final Method getter;
    private final Type type;
    private final AMFSpecialValueFactory.SpecialValueFactory<?> factory;

    public MethodProperty(Converters converters, String name, Method setter, Method getter) {
        super(converters, name);
        this.setter = setter;
        this.getter = getter;
        this.type = getter != null ? getter.getGenericReturnType() : setter.getParameterTypes()[0];
        this.factory = specialValueFactory.getValueFactory(this);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass, boolean recursive) {
        if (this.getter != null) {
            if (this.getter.isAnnotationPresent(annotationClass)) {
                return true;
            }
            if (recursive && TypeUtil.isAnnotationPresent(this.getter, annotationClass)) {
                return true;
            }
        }
        if (this.setter != null) {
            if (this.setter.isAnnotationPresent(annotationClass)) {
                return true;
            }
            if (recursive && TypeUtil.isAnnotationPresent(this.setter, annotationClass)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, boolean recursive) {
        TypeUtil.DeclaredAnnotation<T> declaredAnnotation;
        T annotation = null;
        if (this.getter != null && (annotation = (T)this.getter.getAnnotation(annotationClass)) == null && recursive && (declaredAnnotation = TypeUtil.getAnnotation(this.getter, annotationClass)) != null) {
            annotation = declaredAnnotation.annotation;
        }
        if (annotation == null && this.setter != null && (annotation = (T)this.setter.getAnnotation(annotationClass)) == null && recursive && (declaredAnnotation = TypeUtil.getAnnotation(this.setter, annotationClass)) != null) {
            annotation = declaredAnnotation.annotation;
        }
        return annotation;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getter != null ? this.getter.getDeclaringClass() : this.setter.getDeclaringClass();
    }

    @Override
    public void setValue(Object instance, Object value, boolean convert) {
        try {
            this.setter.invoke(instance, convert ? this.convert(value) : value);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public Object getValue(Object instance) {
        try {
            Object o = this.getter.invoke(instance, new Object[0]);
            if (this.factory != null) {
                o = this.factory.create(o);
            }
            return o;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

