/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.process;

import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.util.Iterator;
import java.util.List;
import org.granite.context.AMFContextImpl;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF0Body;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.AMF3Object;
import org.granite.messaging.amf.process.AMF3MessageProcessor;
import org.granite.util.UUIDUtil;

public abstract class AMF0MessageProcessor {
    private static final Logger log = Logger.getLogger(AMF0MessageProcessor.class);

    public static AMF0Message process(AMF0Message amf0RequestMessage) {
        log.debug(">> Processing AMF0 request:%s", amf0RequestMessage);
        GraniteContext context = GraniteContext.getCurrentInstance();
        AMFContextImpl amf = (AMFContextImpl)context.getAMFContext();
        AMF0Message amf0ResponseMessage = new AMF0Message();
        amf0ResponseMessage.setVersion(amf0RequestMessage.getVersion());
        ErrorMessage loginError = null;
        String dsId = null;
        Iterator<AMF0Body> bodies = amf0RequestMessage.getBodies();
        while (bodies.hasNext()) {
            AMF0Body requestBody = bodies.next();
            Object value = requestBody.getValue();
            Message amf3RequestMessage = null;
            amf3RequestMessage = value instanceof List ? (Message)((List)value).get(0) : (Message)((Object[])value)[0];
            log.debug(">> Processing AMF3 request:\n%s", amf3RequestMessage);
            Message amf3ResponseMessage = null;
            if (loginError == null) {
                amf.setCurrentAmf3Message(amf3RequestMessage);
                amf.getCustomResponseHeaders().clear();
                amf3ResponseMessage = AMF3MessageProcessor.process(amf3RequestMessage);
                if (amf3ResponseMessage instanceof ErrorMessage && ((ErrorMessage)amf3ResponseMessage).loginError()) {
                    loginError = (ErrorMessage)amf3ResponseMessage;
                }
                if ("nil".equals(amf3ResponseMessage.getHeader("DSId"))) {
                    amf3ResponseMessage.getHeaders().put("DSId", dsId == null ? UUIDUtil.randomUUID() : dsId);
                }
                amf3ResponseMessage.getHeaders().putAll(amf.getCustomResponseHeaders());
            } else {
                amf3ResponseMessage = loginError.copy(amf3RequestMessage);
            }
            log.debug("<< Got AMF3 response:\n%s", amf3ResponseMessage);
            AMF3Object data = new AMF3Object(amf3ResponseMessage);
            AMF0Body responseBody = new AMF0Body(AMF0MessageProcessor.getResponseTarget(requestBody, amf3ResponseMessage), "", data, 17);
            amf0ResponseMessage.addBody(responseBody);
        }
        log.debug("<< Returning AMF0 response:%s", amf0ResponseMessage);
        return amf0ResponseMessage;
    }

    private static String getResponseTarget(AMF0Body requestBody, Message responseMessage) {
        if (responseMessage instanceof ErrorMessage) {
            return requestBody.getResponse() + "/onStatus";
        }
        return requestBody.getResponse() + "/onResult";
    }
}

