/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.types;

import java.io.Externalizable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.types.AMFBasicVectorObjectAliaser;
import org.granite.messaging.amf.types.AMFDictionary;
import org.granite.messaging.amf.types.AMFDictionaryValue;
import org.granite.messaging.amf.types.AMFSpecialValue;
import org.granite.messaging.amf.types.AMFVectorInt;
import org.granite.messaging.amf.types.AMFVectorIntValue;
import org.granite.messaging.amf.types.AMFVectorNumber;
import org.granite.messaging.amf.types.AMFVectorNumberValue;
import org.granite.messaging.amf.types.AMFVectorObject;
import org.granite.messaging.amf.types.AMFVectorObjectAliaser;
import org.granite.messaging.amf.types.AMFVectorObjectValue;
import org.granite.messaging.amf.types.AMFVectorUint;
import org.granite.messaging.amf.types.AMFVectorUintValue;
import org.granite.util.TypeUtil;

public class AMFSpecialValueFactory {
    protected final AMFVectorObjectAliaser vectorObjectAlias;

    public AMFSpecialValueFactory() {
        this(null);
    }

    public AMFSpecialValueFactory(AMFVectorObjectAliaser vectorObjectAlias) {
        this.vectorObjectAlias = vectorObjectAlias != null ? vectorObjectAlias : new AMFBasicVectorObjectAliaser();
    }

    public SpecialValueFactory<?> getValueFactory(Property property) {
        Type propertyType = property.getType();
        Class<?> type = TypeUtil.classOfType(propertyType);
        if (!Externalizable.class.isAssignableFrom(type)) {
            if (type.isArray() && type.getComponentType() != Byte.TYPE || Collection.class.isAssignableFrom(type)) {
                if (property.isAnnotationPresent(AMFVectorInt.class)) {
                    return new AMFVectorIntValueFactory(property.getAnnotation(AMFVectorInt.class));
                }
                if (property.isAnnotationPresent(AMFVectorNumber.class)) {
                    return new AMFVectorNumberValueFactory(property.getAnnotation(AMFVectorNumber.class));
                }
                if (property.isAnnotationPresent(AMFVectorUint.class)) {
                    return new AMFVectorUintValueFactory(property.getAnnotation(AMFVectorUint.class));
                }
                if (property.isAnnotationPresent(AMFVectorObject.class)) {
                    AMFVectorObject annotation = property.getAnnotation(AMFVectorObject.class);
                    String vectorComponentType = annotation.type();
                    if (vectorComponentType == null || vectorComponentType.length() == 0) {
                        Class<?> componentClass = TypeUtil.componentClassOfType(propertyType);
                        vectorComponentType = this.vectorObjectAlias.aliasFor(componentClass);
                    }
                    return new AMFVectorObjectValueFactory(annotation, vectorComponentType);
                }
            } else if (Map.class.isAssignableFrom(type) && property.isAnnotationPresent(AMFDictionary.class)) {
                return new AMFDictionaryValueFactory(property.getAnnotation(AMFDictionary.class));
            }
        }
        return null;
    }

    public class AMFDictionaryValueFactory
    implements SpecialValueFactory<AMFDictionaryValue> {
        private final AMFDictionary annotation;

        public AMFDictionaryValueFactory(AMFDictionary annotation) {
            this.annotation = annotation;
        }

        @Override
        public AMFDictionaryValue create(Object o) {
            return o != null ? new AMFDictionaryValue((Map)o, this.annotation.weakKeys()) : null;
        }
    }

    public class AMFVectorObjectValueFactory
    implements SpecialValueFactory<AMFVectorObjectValue> {
        private final AMFVectorObject annotation;
        private final String type;

        public AMFVectorObjectValueFactory(AMFVectorObject annotation, String type) {
            this.annotation = annotation;
            this.type = type;
        }

        @Override
        public AMFVectorObjectValue create(Object o) {
            return o != null ? new AMFVectorObjectValue(o, this.type, this.annotation.fixed()) : null;
        }
    }

    public class AMFVectorNumberValueFactory
    implements SpecialValueFactory<AMFVectorNumberValue> {
        private final AMFVectorNumber annotation;

        public AMFVectorNumberValueFactory(AMFVectorNumber annotation) {
            this.annotation = annotation;
        }

        @Override
        public AMFVectorNumberValue create(Object o) {
            return o != null ? new AMFVectorNumberValue(o, this.annotation.fixed()) : null;
        }
    }

    public class AMFVectorUintValueFactory
    implements SpecialValueFactory<AMFVectorUintValue> {
        private final AMFVectorUint annotation;

        public AMFVectorUintValueFactory(AMFVectorUint annotation) {
            this.annotation = annotation;
        }

        @Override
        public AMFVectorUintValue create(Object o) {
            return o != null ? new AMFVectorUintValue(o, this.annotation.fixed()) : null;
        }
    }

    public class AMFVectorIntValueFactory
    implements SpecialValueFactory<AMFVectorIntValue> {
        private final AMFVectorInt annotation;

        public AMFVectorIntValueFactory(AMFVectorInt annotation) {
            this.annotation = annotation;
        }

        @Override
        public AMFVectorIntValue create(Object o) {
            return o != null ? new AMFVectorIntValue(o, this.annotation.fixed()) : null;
        }
    }

    public static interface SpecialValueFactory<T extends AMFSpecialValue<?>> {
        public T create(Object var1);
    }
}

