/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.SharedContext;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.reflect.Property;
import org.granite.messaging.reflect.Reflection;

public class JMFSerializer
implements OutputContext {
    protected final Map<String, Integer> classNames = new HashMap<String, Integer>(256);
    protected final Map<String, Integer> strings = new HashMap<String, Integer>(256);
    protected final Map<Object, Integer> objects = new IdentityHashMap<Object, Integer>(256);
    protected final OutputStream outputStream;
    protected final SharedContext context;
    protected final CodecRegistry codecRegistry;

    public JMFSerializer(OutputStream outputStream, SharedContext context) {
        this.outputStream = outputStream;
        this.codecRegistry = context.getCodecRegistry();
        this.context = context;
        for (String s : context.getInitialClassNameDictionary()) {
            this.addToClassNames(s);
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.codecRegistry.getBooleanCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.codecRegistry.getByteCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.codecRegistry.getShortCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.codecRegistry.getCharacterCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.codecRegistry.getIntegerCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.codecRegistry.getLongCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.codecRegistry.getFloatCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.codecRegistry.getDoubleCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        if (s == null) {
            this.codecRegistry.getNullCodec().encode((OutputContext)this, s);
        } else {
            this.codecRegistry.getStringCodec().encode((OutputContext)this, s);
        }
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        StandardCodec<Object> codec = this.codecRegistry.getCodec(this, obj);
        if (codec == null) {
            throw new JMFEncodingException("Unsupported Java class: " + obj);
        }
        try {
            codec.encode(this, obj);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    @Deprecated
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    @Deprecated
    public void write(byte[] b) throws IOException {
        this.writeObject(b);
    }

    @Override
    @Deprecated
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeObject(Arrays.copyOfRange(b, off, off + len));
    }

    @Override
    @Deprecated
    public void writeBytes(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    @Deprecated
    public void writeChars(String s) throws IOException {
        this.writeUTF(s);
    }

    @Override
    public SharedContext getSharedContext() {
        return this.context;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void addToClassNames(String className) {
        if (className != null && !this.classNames.containsKey(className)) {
            Integer index = this.classNames.size();
            this.classNames.put(className, index);
        }
    }

    @Override
    public int indexOfClassName(String className) {
        Integer index;
        if (className != null && (index = this.classNames.get(className)) != null) {
            return index;
        }
        return -1;
    }

    @Override
    public void addToStrings(String s) {
        if (s != null && !this.strings.containsKey(s)) {
            Integer index = this.strings.size();
            this.strings.put(s, index);
        }
    }

    @Override
    public int indexOfString(String s) {
        Integer index;
        if (s != null && (index = this.strings.get(s)) != null) {
            return index;
        }
        return -1;
    }

    @Override
    public void addToObjects(Object o) {
        if (o != null && !this.objects.containsKey(o)) {
            Integer index = this.objects.size();
            this.objects.put(o, index);
        }
    }

    @Override
    public int indexOfObject(Object o) {
        Integer index;
        if (o != null && (index = this.objects.get(o)) != null) {
            return index;
        }
        return -1;
    }

    @Override
    public Reflection getReflection() {
        return this.context.getReflection();
    }

    @Override
    public String getAlias(String className) {
        return this.context.getRemoteAlias(className);
    }

    @Override
    public void getAndWriteProperty(Object obj, Property property) throws IOException, IllegalAccessException, InvocationTargetException {
        if (property.getType().isPrimitive()) {
            this.codecRegistry.getPrimitivePropertyCodec(property.getType()).encodePrimitive(this, obj, property);
        } else {
            this.writeObject(property.getObject(obj));
        }
    }

    public String toDumpString() {
        Comparator comparator = new Comparator<Map.Entry<?, Integer>>(){

            @Override
            public int compare(Map.Entry<?, Integer> o1, Map.Entry<?, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        };
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(" {\n");
        TreeSet<Map.Entry<String, Integer>> setStringInteger = new TreeSet<Map.Entry<String, Integer>>(comparator);
        setStringInteger.addAll(this.classNames.entrySet());
        sb.append("    classNames=[\n");
        for (Map.Entry entry : setStringInteger) {
            sb.append("        ").append(entry.getValue()).append(": \"").append((String)entry.getKey()).append("\"\n");
        }
        sb.append("    ],\n");
        setStringInteger = new TreeSet(comparator);
        setStringInteger.addAll(this.strings.entrySet());
        sb.append("    strings=[\n");
        for (Map.Entry entry : setStringInteger) {
            sb.append("        ").append(entry.getValue()).append(": \"").append((String)entry.getKey()).append("\"\n");
        }
        sb.append("    ],\n");
        TreeSet<Map.Entry<Object, Integer>> setObjectInteger = new TreeSet<Map.Entry<Object, Integer>>(comparator);
        setObjectInteger.addAll(this.objects.entrySet());
        sb.append("    objects=[\n");
        for (Map.Entry entry : setObjectInteger) {
            sb.append("        ").append(entry.getValue()).append(": ").append(entry.getKey().getClass().getName()).append("@").append(System.identityHashCode(entry.getKey())).append("\n");
        }
        sb.append("    ]\n");
        sb.append("}");
        return sb.toString();
    }
}

