/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.EnumCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.ClassNameUtil;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;

public class EnumCodecImpl
extends AbstractStandardCodec<Object>
implements EnumCodec {
    protected static final int ORDINAL_BYTE_COUNT_OFFSET = 6;

    @Override
    public int getObjectType() {
        return 28;
    }

    @Override
    public boolean canEncode(Object v) {
        return v.getClass().isEnum();
    }

    @Override
    public void encode(OutputContext ctx, Object v) throws IOException {
        String className = ctx.getAlias(v.getClass().getName());
        int ordinal = ((Enum)v).ordinal();
        int count = IntegerUtil.significantIntegerBytesCount0(ordinal);
        ctx.getOutputStream().write(count << 6 | 0x1C);
        IntegerUtil.encodeInteger(ctx, ordinal, count);
        ClassNameUtil.encodeClassName(ctx, className);
    }

    @Override
    public Object decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException {
        int count = parameterizedJmfType >>> 6;
        int ordinal = IntegerUtil.decodeInteger(ctx, count);
        String className = ctx.getAlias(ClassNameUtil.decodeClassName(ctx));
        Class<?> cls = ctx.getSharedContext().getReflection().loadClass(className);
        return cls.getEnumConstants()[ordinal];
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 28) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int count = parameterizedJmfType >>> 6;
        int ordinal = IntegerUtil.decodeInteger(ctx, count);
        String className = ctx.getAlias(ClassNameUtil.decodeClassName(ctx));
        ctx.indentPrintLn(className + ": <" + ordinal + ">");
    }
}

