/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.jmf.codec.std.HashMapCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;

public class HashMapCodecImpl
extends AbstractStandardCodec<HashMap<?, ?>>
implements HashMapCodec {
    protected static final int INDEX_OR_LENGTH_BYTE_COUNT_OFFSET = 5;

    @Override
    public int getObjectType() {
        return 12;
    }

    @Override
    public Class<?> getObjectClass() {
        return HashMap.class;
    }

    @Override
    public void encode(OutputContext ctx, HashMap<?, ?> v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int indexOfStoredObject = ctx.indexOfObject(v);
        if (indexOfStoredObject >= 0) {
            int count = IntegerUtil.significantIntegerBytesCount0(indexOfStoredObject);
            os.write(0x80 | count << 5 | 0xC);
            IntegerUtil.encodeInteger(ctx, indexOfStoredObject, count);
        } else {
            ctx.addToObjects(v);
            Map.Entry[] snapshot = v.entrySet().toArray(new Map.Entry[0]);
            int count = IntegerUtil.significantIntegerBytesCount0(snapshot.length);
            os.write(count << 5 | 0xC);
            IntegerUtil.encodeInteger(ctx, snapshot.length, count);
            for (Map.Entry entry : snapshot) {
                ctx.writeObject(entry.getKey());
                ctx.writeObject(entry.getValue());
            }
        }
    }

    @Override
    public HashMap<?, ?> decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException {
        int indexOrLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 5 & 3);
        if ((parameterizedJmfType & 0x80) != 0) {
            return (HashMap)ctx.getObject(indexOrLength);
        }
        HashMap<Object, Object> v = new HashMap<Object, Object>(indexOrLength);
        ctx.addToObjects(v);
        for (int index = 0; index < indexOrLength; ++index) {
            Object key = ctx.readObject();
            Object value = ctx.readObject();
            v.put(key, value);
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 12) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 5 & 3);
        if ((parameterizedJmfType & 0x80) != 0) {
            String v = (String)ctx.getObject(indexOrLength);
            ctx.indentPrintLn("<" + v + "@" + indexOrLength + ">");
            return;
        }
        String v = HashMap.class.getName() + "[" + indexOrLength + "]";
        int indexOfStoredObject = ctx.addToObjects(v);
        ctx.indentPrintLn(v + "@" + indexOfStoredObject + " {");
        ctx.incrIndent(1);
        for (int index = 0; index < indexOrLength; ++index) {
            parameterizedJmfType = ctx.safeRead();
            jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
            StandardCodec codec = codecRegistry.getCodec(jmfType);
            if (codec == null) {
                throw new JMFEncodingException("No codec for JMF type: " + jmfType);
            }
            codec.dump(ctx, parameterizedJmfType);
            ctx.incrIndent(1);
            parameterizedJmfType = ctx.safeRead();
            jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
            codec = codecRegistry.getCodec(jmfType);
            if (codec == null) {
                throw new JMFEncodingException("No codec for JMF type: " + jmfType);
            }
            codec.dump(ctx, parameterizedJmfType);
            ctx.incrIndent(-1);
        }
        ctx.incrIndent(-1);
        ctx.indentPrintLn("}");
    }
}

