/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.LongCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.LongUtil;

public class LongCodecImpl
extends AbstractStandardCodec<Long>
implements LongCodec {
    protected static final int LENGTH_BYTE_COUNT_OFFSET = 4;

    @Override
    public int getObjectType() {
        return 3;
    }

    @Override
    public Class<?> getObjectClass() {
        return Long.class;
    }

    @Override
    public int getPrimitiveType() {
        return 2;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Long.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Long v) throws IOException {
        this.writeLongData(ctx, 3, v);
    }

    @Override
    public Long decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        return this.readLongData(ctx, parameterizedJmfType);
    }

    @Override
    public void encodePrimitive(OutputContext ctx, long v) throws IOException {
        this.writeLongData(ctx, 2, v);
    }

    @Override
    public long decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        return this.readLongData(ctx, parameterizedJmfType);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 2: {
                ctx.indentPrintLn("long: " + this.readLongData(ctx, parameterizedJmfType));
                break;
            }
            case 3: {
                ctx.indentPrintLn(Long.class.getName() + ": " + Long.valueOf(this.readLongData(ctx, parameterizedJmfType)));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }

    protected void writeLongData(OutputContext ctx, int jmfType, long v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int opposite = 0;
        if (v < 0L && v != Long.MIN_VALUE) {
            opposite = 128;
            v = -v;
        }
        int count = LongUtil.significantLongBytesCount0(v);
        os.write(opposite | count << 4 | jmfType);
        LongUtil.encodeLong(ctx, v, count);
    }

    protected long readLongData(InputContext ctx, int parameterizedJmfType) throws IOException {
        long v = LongUtil.decodeLong(ctx, parameterizedJmfType >>> 4 & 7);
        if ((parameterizedJmfType & 0x80) != 0) {
            v = -v;
        }
        return v;
    }
}

