/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.ServletGraniteContext;

public class Jetty8SecurityService
extends AbstractSecurityService {
    @Override
    public void configure(Map<String, String> params) {
    }

    @Override
    public void prelogin(HttpSession session, Object httpRequest, String servletName) {
        if (session == null) {
            return;
        }
        if (session.getAttribute(SecurityService.AuthenticationContext.class.getName()) instanceof Jetty8AuthenticationContext) {
            return;
        }
        Request request = (Request)httpRequest;
        Authentication authentication = request.getAuthentication();
        UserIdentity.Scope scope = request.getUserIdentityScope();
        Jetty8AuthenticationContext authorizationContext = new Jetty8AuthenticationContext(scope, authentication);
        session.setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authorizationContext);
    }

    @Override
    public Principal login(Object credentials, String charset) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials, charset);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        Principal principal = null;
        if (graniteContext instanceof HttpGraniteContext) {
            HttpServletRequest httpRequest = graniteContext.getRequest();
            Request request = (Request)httpRequest;
            Authentication authentication = request.getAuthentication();
            UserIdentity.Scope scope = request.getUserIdentityScope();
            Jetty8AuthenticationContext authenticationContext = new Jetty8AuthenticationContext(scope, authentication);
            principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            if (principal != null) {
                graniteContext.getSession().setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authenticationContext);
            }
        } else {
            SecurityService.AuthenticationContext authenticationContext = (SecurityService.AuthenticationContext)graniteContext.getSession().getAttribute(SecurityService.AuthenticationContext.class.getName());
            if (authenticationContext != null) {
                principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            } else {
                return null;
            }
        }
        if (principal == null) {
            throw SecurityServiceException.newInvalidCredentialsException("Wrong username or password");
        }
        graniteContext.setPrincipal(principal);
        this.endLogin(credentials, charset);
        return principal;
    }

    @Override
    public Object authorize(AbstractSecurityContext context) throws Exception {
        HttpSession session;
        this.startAuthorization(context);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = null;
        SecurityService.AuthenticationContext authenticationContext = null;
        Principal principal = null;
        if (graniteContext instanceof HttpGraniteContext) {
            httpRequest = graniteContext.getRequest();
            session = httpRequest.getSession(false);
            if (session != null) {
                Request request;
                Authentication authentication;
                authenticationContext = (SecurityService.AuthenticationContext)session.getAttribute(SecurityService.AuthenticationContext.class.getName());
                if (authenticationContext != null) {
                    principal = authenticationContext.getPrincipal();
                    ((Request)httpRequest).setAuthentication(((Jetty8AuthenticationContext)authenticationContext).getAuthentication());
                }
                if (principal == null && this.tryRelogin() && (authentication = (request = (Request)httpRequest).getAuthentication()) instanceof Authentication.User) {
                    principal = ((Authentication.User)authentication).getUserIdentity().getUserPrincipal();
                }
            }
        } else {
            session = graniteContext.getSession(false);
            if (session != null && (authenticationContext = (SecurityService.AuthenticationContext)session.getAttribute(SecurityService.AuthenticationContext.class.getName())) != null) {
                principal = authenticationContext.getPrincipal();
            }
        }
        graniteContext.setPrincipal(principal);
        if (context.getDestination().isSecured()) {
            if (principal == null) {
                HttpSession httpSession;
                if (!(httpRequest == null || httpRequest.getRequestedSessionId() == null || (httpSession = httpRequest.getSession(false)) != null && httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                    throw SecurityServiceException.newSessionExpiredException("Session expired");
                }
                throw SecurityServiceException.newNotLoggedInException("User not logged in");
            }
            if (httpRequest == null && authenticationContext == null) {
                throw SecurityServiceException.newNotLoggedInException("No authorization context");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (httpRequest != null && httpRequest.isUserInRole(role)) {
                    accessDenied = false;
                    break;
                }
                if (authenticationContext == null || !authenticationContext.isUserInRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException("User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (!(t instanceof SecurityException)) continue;
                throw SecurityServiceException.newAccessDeniedException(t.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void logout() throws SecurityServiceException {
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        if (graniteContext instanceof HttpGraniteContext) {
            Request request = (Request)graniteContext.getRequest();
            Authentication authentication = request.getAuthentication();
            if (authentication instanceof Authentication.User) {
                ((Authentication.User)authentication).logout();
            }
            if (request.getSession(false) != null) {
                this.endLogout();
                try {
                    request.getSession(false).invalidate();
                }
                catch (IllegalStateException e) {}
            }
        } else {
            HttpSession session = graniteContext.getSession();
            if (session != null) {
                SecurityService.AuthenticationContext authenticationContext = (SecurityService.AuthenticationContext)session.getAttribute(SecurityService.AuthenticationContext.class.getName());
                authenticationContext.logout();
                try {
                    session.removeAttribute(SecurityService.AuthenticationContext.class.getName());
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                this.endLogout();
                try {
                    session.invalidate();
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
        }
    }

    public static class Jetty8AuthenticationContext
    implements SecurityService.AuthenticationContext {
        private static final long serialVersionUID = 1L;
        private final transient UserIdentity.Scope scope;
        private transient Authentication authentication;
        private transient Principal principal;

        public Jetty8AuthenticationContext(UserIdentity.Scope scope, Authentication authentication) {
            this.scope = scope;
            this.authentication = authentication;
        }

        @Override
        public Principal authenticate(String username, String password) {
            if (this.authentication == null) {
                throw SecurityServiceException.newAuthenticationFailedException("Invalid authentication");
            }
            if (this.authentication instanceof Authentication.Deferred) {
                this.authentication = ((Authentication.Deferred)this.authentication).login(username, (Object)password, (ServletRequest)((ServletGraniteContext)GraniteContext.getCurrentInstance()).getRequest());
            }
            if (this.authentication instanceof Authentication.User) {
                this.principal = ((Authentication.User)this.authentication).getUserIdentity().getUserPrincipal();
            }
            return this.principal;
        }

        public boolean isValid() {
            return this.principal != null;
        }

        @Override
        public Principal getPrincipal() {
            return this.principal;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        @Override
        public boolean isUserInRole(String role) {
            if (this.authentication instanceof Authentication.User) {
                return ((Authentication.User)this.authentication).isUserInRole(this.scope, role);
            }
            return false;
        }

        @Override
        public void logout() {
            if (this.authentication instanceof Authentication.User) {
                ((Authentication.User)this.authentication).logout();
            }
        }
    }
}

