/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.ServletGraniteContext;

public class Tomcat7SecurityService
extends AbstractSecurityService {
    private final Field requestField;

    public Tomcat7SecurityService() {
        try {
            this.requestField = RequestFacade.class.getDeclaredField("request");
            this.requestField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get 'request' field in Tomcat RequestFacade", e);
        }
    }

    @Override
    public void configure(Map<String, String> params) {
    }

    @Override
    public void prelogin(HttpSession session, Object httpRequest, String servletName) {
        if (session == null) {
            return;
        }
        if (session.getAttribute(SecurityService.AuthenticationContext.class.getName()) instanceof Tomcat7AuthenticationContext) {
            return;
        }
        if (httpRequest.getClass().getName().equals("org.apache.tomcat.websocket.server.WsHandshakeRequest")) {
            try {
                Field f = httpRequest.getClass().getDeclaredField("request");
                f.setAccessible(true);
                httpRequest = f.get(httpRequest);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not unwrap Tomcat request from ws handshake", e);
            }
        }
        Request request = this.getRequest((HttpServletRequest)httpRequest);
        Realm realm = this.getRealm(request);
        Tomcat7AuthenticationContext authorizationContext = new Tomcat7AuthenticationContext(realm);
        session.setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authorizationContext);
    }

    @Override
    public Principal login(Object credentials, String charset) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials, charset);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        Principal principal = null;
        Request request = null;
        if (graniteContext instanceof HttpGraniteContext) {
            HttpServletRequest httpRequest = graniteContext.getRequest();
            request = this.getRequest(httpRequest);
            Realm realm = this.getRealm(request);
            Tomcat7AuthenticationContext authenticationContext = new Tomcat7AuthenticationContext(realm);
            principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            if (principal != null) {
                graniteContext.getSession().setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authenticationContext);
            }
        } else {
            SecurityService.AuthenticationContext authenticationContext = (SecurityService.AuthenticationContext)graniteContext.getSession().getAttribute(SecurityService.AuthenticationContext.class.getName());
            if (authenticationContext != null) {
                principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            } else {
                return null;
            }
        }
        if (principal == null) {
            throw SecurityServiceException.newInvalidCredentialsException("Wrong username or password");
        }
        graniteContext.setPrincipal(principal);
        if (graniteContext instanceof HttpGraniteContext) {
            request.setAuthType("granite-security");
            request.setUserPrincipal(principal);
            Session session = request.getSessionInternal();
            session.setAuthType("granite-security");
            session.setPrincipal(principal);
            session.setNote("org.apache.catalina.session.USERNAME", (Object)decoded[0]);
            session.setNote("org.apache.catalina.session.PASSWORD", (Object)decoded[1]);
        }
        this.endLogin(credentials, charset);
        return principal;
    }

    @Override
    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = null;
        SecurityService.AuthenticationContext authenticationContext = null;
        Principal principal = null;
        if (graniteContext instanceof HttpGraniteContext) {
            httpRequest = graniteContext.getRequest();
            Request request = this.getRequest(httpRequest);
            Session session = request.getSessionInternal(false);
            if (session != null) {
                request.setAuthType(session.getAuthType());
                principal = session.getPrincipal();
                if (principal == null && this.tryRelogin()) {
                    principal = session.getPrincipal();
                }
            }
            request.setUserPrincipal(principal);
        } else {
            HttpSession session = graniteContext.getSession(false);
            if (session != null && (authenticationContext = (SecurityService.AuthenticationContext)session.getAttribute(SecurityService.AuthenticationContext.class.getName())) != null) {
                principal = authenticationContext.getPrincipal();
            }
        }
        graniteContext.setPrincipal(principal);
        if (context.getDestination().isSecured()) {
            if (principal == null) {
                HttpSession httpSession;
                if (!(httpRequest == null || httpRequest.getRequestedSessionId() == null || (httpSession = httpRequest.getSession(false)) != null && httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                    throw SecurityServiceException.newSessionExpiredException("Session expired");
                }
                throw SecurityServiceException.newNotLoggedInException("User not logged in");
            }
            if (httpRequest == null && authenticationContext == null) {
                throw SecurityServiceException.newNotLoggedInException("No authorization context");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (httpRequest != null && httpRequest.isUserInRole(role)) {
                    accessDenied = false;
                    break;
                }
                if (authenticationContext == null || !authenticationContext.isUserInRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException("User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (!(t instanceof SecurityException) && !"javax.ejb.EJBAccessException".equals(t.getClass().getName())) continue;
                throw SecurityServiceException.newAccessDeniedException(t.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void logout() throws SecurityServiceException {
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        if (graniteContext instanceof HttpGraniteContext) {
            Session session = this.getSession(graniteContext.getRequest(), false);
            if (session != null && session.getPrincipal() != null && session.isValid()) {
                session.setAuthType(null);
                session.setPrincipal(null);
                session.removeNote("org.apache.catalina.session.USERNAME");
                session.removeNote("org.apache.catalina.session.PASSWORD");
                this.endLogout();
                session.expire();
            }
        } else {
            HttpSession session = graniteContext.getSession();
            if (session != null) {
                try {
                    session.removeAttribute(SecurityService.AuthenticationContext.class.getName());
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                this.endLogout();
                try {
                    session.invalidate();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    protected Principal getPrincipal(HttpServletRequest httpRequest) {
        Request request = this.getRequest(httpRequest);
        Session session = request.getSessionInternal(false);
        return session != null ? session.getPrincipal() : null;
    }

    protected Session getSession(HttpServletRequest httpRequest, boolean create) {
        Request request = this.getRequest(httpRequest);
        return request.getSessionInternal(create);
    }

    protected Request getRequest(HttpServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        try {
            return (Request)this.requestField.get(request);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get tomcat request", e);
        }
    }

    protected Realm getRealm(Request request) {
        String serverName = request.getServerName();
        String contextPath = request.getContextPath();
        Context context = request.getContext();
        if (context == null) {
            throw new NullPointerException("Could not find Tomcat context for: " + contextPath);
        }
        Realm realm = context.getRealm();
        if (realm == null) {
            throw new NullPointerException("Could not find Tomcat realm for: " + serverName + "" + contextPath);
        }
        return realm;
    }

    public static class Tomcat7AuthenticationContext
    implements SecurityService.AuthenticationContext {
        private static final long serialVersionUID = 1L;
        private final transient Realm realm;
        private transient Principal principal;

        public Tomcat7AuthenticationContext(Realm realm) {
            this.realm = realm;
        }

        @Override
        public Principal authenticate(String username, String password) {
            if (this.realm == null) {
                throw SecurityServiceException.newAuthenticationFailedException("Invalid authentication");
            }
            this.principal = this.realm.authenticate(username, password);
            return this.principal;
        }

        @Override
        public Principal getPrincipal() {
            return this.principal;
        }

        @Override
        public boolean isUserInRole(String role) {
            return this.realm.hasRole(null, this.principal, role);
        }

        @Override
        public void logout() {
        }
    }
}

