/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;

public class TomcatSecurityService
extends AbstractSecurityService {
    private final Field requestField;
    private Engine engine = null;

    public TomcatSecurityService() {
        try {
            this.requestField = RequestFacade.class.getDeclaredField("request");
            this.requestField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get 'request' field in Tomcat RequestFacade", e);
        }
    }

    protected Field getRequestField() {
        return this.requestField;
    }

    protected Engine getEngine() {
        return this.engine;
    }

    @Override
    public void configure(Map<String, String> params) {
        String serviceId = params.get("service");
        Server server = ServerFactory.getServer();
        if (server == null) {
            throw new NullPointerException("Could not get Tomcat server");
        }
        Service service = null;
        if (serviceId != null) {
            service = server.findService(serviceId);
        } else {
            Service[] services = server.findServices();
            if (services != null && services.length > 0) {
                service = services[0];
            }
        }
        if (service == null) {
            throw new NullPointerException("Could not find Tomcat service for: " + (serviceId != null ? serviceId : "(default)"));
        }
        this.engine = (Engine)service.getContainer();
        if (this.engine == null) {
            throw new NullPointerException("Could not find Tomcat container for: " + (serviceId != null ? serviceId : "(default)"));
        }
    }

    @Override
    public Principal login(Object credentials, String charset) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials, charset);
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = context.getRequest();
        Realm realm = this.getRealm(httpRequest);
        Principal principal = realm.authenticate(decoded[0], decoded[1]);
        if (principal == null) {
            throw SecurityServiceException.newInvalidCredentialsException("Wrong username or password");
        }
        Request request = this.getRequest(httpRequest);
        request.setAuthType("granite-security");
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(true);
        session.setAuthType("granite-security");
        session.setPrincipal(principal);
        session.setNote("org.apache.catalina.session.USERNAME", (Object)decoded[0]);
        session.setNote("org.apache.catalina.session.PASSWORD", (Object)decoded[1]);
        this.endLogin(credentials, charset);
        return principal;
    }

    @Override
    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        Request request = this.getRequest(httpRequest);
        Session session = request.getSessionInternal(false);
        Principal principal = null;
        if (session != null) {
            request.setAuthType(session.getAuthType());
            principal = session.getPrincipal();
            if (principal == null && this.tryRelogin()) {
                principal = session.getPrincipal();
            }
        }
        request.setUserPrincipal(principal);
        if (context.getDestination().isSecured()) {
            if (principal == null) {
                HttpSession httpSession;
                if (httpRequest.getRequestedSessionId() != null && ((httpSession = httpRequest.getSession(false)) == null || httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                    throw SecurityServiceException.newSessionExpiredException("Session expired");
                }
                throw SecurityServiceException.newNotLoggedInException("User not logged in");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (!request.isUserInRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException("User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (!(t instanceof SecurityException) && !"javax.ejb.EJBAccessException".equals(t.getClass().getName())) continue;
                throw SecurityServiceException.newAccessDeniedException(t.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void logout() throws SecurityServiceException {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        Session session = this.getSession(context.getRequest(), false);
        if (session != null && session.getPrincipal() != null) {
            session.setAuthType(null);
            session.setPrincipal(null);
            session.removeNote("org.apache.catalina.session.USERNAME");
            session.removeNote("org.apache.catalina.session.PASSWORD");
            this.endLogout();
            session.expire();
        }
    }

    protected Principal getPrincipal(HttpServletRequest httpRequest) {
        Request request = this.getRequest(httpRequest);
        Session session = request.getSessionInternal(false);
        return session != null ? session.getPrincipal() : null;
    }

    protected Session getSession(HttpServletRequest httpRequest, boolean create) {
        Request request = this.getRequest(httpRequest);
        return request.getSessionInternal(create);
    }

    protected Request getRequest(HttpServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        try {
            return (Request)this.requestField.get(request);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get tomcat request", e);
        }
    }

    protected Context getContext(HttpServletRequest request) {
        String serverName = request.getServerName();
        String contextPath = request.getContextPath();
        Host host = (Host)this.engine.findChild(serverName);
        if (host == null && (host = (Host)this.engine.findChild(this.engine.getDefaultHost())) == null) {
            throw new NullPointerException("Could not find Tomcat host for: " + serverName + " or: " + this.engine.getDefaultHost());
        }
        Context context = (Context)host.findChild(contextPath);
        if (context == null) {
            throw new NullPointerException("Could not find Tomcat context for: " + contextPath);
        }
        return context;
    }

    protected Realm getRealm(HttpServletRequest request) {
        Context context = this.getContext(request);
        Realm realm = context.getRealm();
        if (realm == null) {
            throw new NullPointerException("Could not find Tomcat realm for: " + context.getPath());
        }
        return realm;
    }
}

