/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.ServletGraniteContext;

public class UndertowSecurityService
extends AbstractSecurityService {
    @Override
    public void configure(Map<String, String> params) {
    }

    @Override
    public void prelogin(HttpSession session, Object request, String servletName) {
        if (session == null) {
            return;
        }
        if (session.getAttribute(SecurityService.AuthenticationContext.class.getName()) instanceof UndertowAuthenticationContext) {
            return;
        }
        HttpServerExchange exchange = null;
        if (request instanceof HttpServletRequestImpl) {
            exchange = ((HttpServletRequestImpl)request).getExchange();
        } else if (request.getClass().getSimpleName().equals("ExchangeHandshakeRequest")) {
            Field f = null;
            try {
                f = request.getClass().getDeclaredField("exchange");
                f.setAccessible(true);
                Object wsExchange = f.get(request);
                f = wsExchange.getClass().getDeclaredField("exchange");
                f.setAccessible(true);
                exchange = (HttpServerExchange)f.get(wsExchange);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get internal undertow exchange", e);
            }
        }
        SecurityContext securityContext = exchange.getSecurityContext();
        UndertowAuthenticationContext authenticationContext = new UndertowAuthenticationContext(securityContext);
        session.setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authenticationContext);
    }

    @Override
    public Principal login(Object credentials, String charset) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials, charset);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        Principal principal = null;
        if (graniteContext instanceof HttpGraniteContext) {
            HttpServletRequest httpRequest = graniteContext.getRequest();
            HttpServerExchange exchange = ((HttpServletRequestImpl)httpRequest).getExchange();
            SecurityContext securityContext = exchange.getSecurityContext();
            UndertowAuthenticationContext authenticationContext = new UndertowAuthenticationContext(securityContext);
            principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            if (principal != null) {
                graniteContext.getSession().setAttribute(SecurityService.AuthenticationContext.class.getName(), (Object)authenticationContext);
            }
        } else {
            SecurityService.AuthenticationContext authenticationContext = (SecurityService.AuthenticationContext)graniteContext.getSession().getAttribute(SecurityService.AuthenticationContext.class.getName());
            if (authenticationContext != null) {
                principal = authenticationContext.authenticate(decoded[0], decoded[1]);
            } else {
                return null;
            }
        }
        if (principal == null) {
            throw SecurityServiceException.newInvalidCredentialsException("Wrong username or password");
        }
        graniteContext.setPrincipal(principal);
        this.endLogin(credentials, charset);
        return principal;
    }

    @Override
    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = null;
        SecurityService.AuthenticationContext authenticationContext = null;
        Principal principal = null;
        if (graniteContext instanceof HttpGraniteContext) {
            httpRequest = graniteContext.getRequest();
            HttpServerExchange exchange = ((HttpServletRequestImpl)httpRequest).getExchange();
            if (exchange.getSecurityContext() == null || exchange.getSecurityContext().getAuthenticatedAccount() == null) {
                this.tryRelogin();
            }
            if (exchange.getSecurityContext() != null && exchange.getSecurityContext().getAuthenticatedAccount() != null) {
                principal = exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal();
            }
        } else {
            HttpSession session = graniteContext.getSession(false);
            if (session != null && (authenticationContext = (SecurityService.AuthenticationContext)session.getAttribute(SecurityService.AuthenticationContext.class.getName())) != null) {
                principal = authenticationContext.getPrincipal();
            }
        }
        graniteContext.setPrincipal(principal);
        if (context.getDestination().isSecured()) {
            if (principal == null) {
                HttpSession httpSession;
                if (!(httpRequest == null || httpRequest.getRequestedSessionId() == null || (httpSession = httpRequest.getSession(false)) != null && httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                    throw SecurityServiceException.newSessionExpiredException("Session expired");
                }
                throw SecurityServiceException.newNotLoggedInException("User not logged in");
            }
            if (httpRequest == null && authenticationContext == null) {
                throw SecurityServiceException.newNotLoggedInException("No authorization context");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (httpRequest != null && httpRequest.isUserInRole(role)) {
                    accessDenied = false;
                    break;
                }
                if (authenticationContext == null || !authenticationContext.isUserInRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException("User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (!(t instanceof SecurityException) && !"javax.ejb.EJBAccessException".equals(t.getClass().getName())) continue;
                throw SecurityServiceException.newAccessDeniedException(t.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void logout() throws SecurityServiceException {
        HttpSession session;
        ServletGraniteContext graniteContext = (ServletGraniteContext)GraniteContext.getCurrentInstance();
        if (graniteContext instanceof HttpGraniteContext) {
            HttpServletRequest httpRequest = graniteContext.getRequest();
            HttpServerExchange exchange = ((HttpServletRequestImpl)httpRequest).getExchange();
            SecurityContext securityContext = exchange.getSecurityContext();
            securityContext.logout();
        }
        if ((session = graniteContext.getSession(false)) != null) {
            this.endLogout();
            session.invalidate();
        }
    }

    public static class UndertowAuthenticationContext
    implements SecurityService.AuthenticationContext {
        private static final long serialVersionUID = 1L;
        private final transient SecurityContext securityContext;
        private transient Principal principal = null;
        private String username = null;

        public UndertowAuthenticationContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
        }

        @Override
        public Principal authenticate(String username, String password) {
            if (this.securityContext == null) {
                throw SecurityServiceException.newAuthenticationFailedException("Invalid authentication");
            }
            if (username.equals(this.username) && this.principal != null) {
                return this.principal;
            }
            boolean authenticated = this.securityContext.login(username, password);
            if (authenticated) {
                this.username = username;
                this.principal = this.securityContext.getAuthenticatedAccount().getPrincipal();
            }
            return this.principal;
        }

        @Override
        public Principal getPrincipal() {
            return this.principal;
        }

        @Override
        public boolean isUserInRole(String role) {
            return this.securityContext.getAuthenticatedAccount().getRoles().contains(role);
        }

        @Override
        public void logout() {
            this.securityContext.logout();
        }
    }
}

