/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.InputStream;
import java.util.Properties;
import org.granite.logging.Logger;
import org.granite.scan.ScannedItemHandler;
import org.granite.scan.Scanner;
import org.granite.scan.URLScanner;

public class ScannerFactory {
    private static final Logger log = Logger.getLogger(ScannerFactory.class);

    public static Scanner createScanner(ScannedItemHandler handler, String marker) {
        if (ScannerFactory.isVFSAvailable() && !ScannerFactory.isEmbedded() && ScannerFactory.isJBoss(5)) {
            log.debug("Using VFS aware scanner", new Object[0]);
            try {
                Class<?> vfsScannerClass = ScannerFactory.class.getClassLoader().loadClass("org.granite.scan.VFSScanner");
                return (Scanner)vfsScannerClass.getConstructor(ScannedItemHandler.class, String.class).newInstance(handler, marker);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create VFSScanner", e);
            }
        }
        if (ScannerFactory.isVFS3Available()) {
            try {
                Class<?> vfsScannerClass = ScannerFactory.class.getClassLoader().loadClass("org.granite.scan.VFS3Scanner");
                log.debug("Using VFS3 aware scanner", new Object[0]);
                return (Scanner)vfsScannerClass.getConstructor(ScannedItemHandler.class, String.class).newInstance(handler, marker);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.debug("Using default scanner", new Object[0]);
        return new URLScanner(handler, marker);
    }

    private static boolean isVFSAvailable() {
        try {
            Class.forName("org.jboss.virtual.VFS");
            log.trace("VFS detected", new Object[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isVFS3Available() {
        try {
            Class.forName("org.jboss.vfs.VFS");
            log.trace("VFS3 detected", new Object[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isJBoss(int version) {
        try {
            Properties props = new Properties();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/org/jboss/version.properties");
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/version.properties");
            }
            if (is != null) {
                boolean isJBossVersion;
                props.load(is);
                is.close();
                int major = Integer.parseInt(props.getProperty("version.major"));
                int minor = Integer.parseInt(props.getProperty("version.minor"));
                boolean bl = isJBossVersion = major >= version && minor >= 0;
                if (isJBossVersion) {
                    log.trace("JBoss " + major + "." + minor + " detected", new Object[0]);
                }
                return isJBossVersion;
            }
            log.trace("JBoss AS 7+ detected", new Object[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isEmbedded() {
        try {
            ScannerFactory.class.getClassLoader().loadClass("org.jboss.embedded.Bootstrap");
            log.trace("JBoss Embedded detected", new Object[0]);
            return true;
        }
        catch (Throwable t) {
            try {
                ScannerFactory.class.getClassLoader().loadClass("org.jboss.as.embedded.EmbeddedServerFactory");
                log.trace("JBoss AS 7+ Embedded detected", new Object[0]);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }
}

