/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.simple;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.granite.logging.Logger;
import org.granite.messaging.service.annotations.RemoteDestination;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.tide.util.Observer;

public class SimpleScannedItemHandler
implements ScannedItemHandler {
    private static final Logger log = Logger.getLogger(SimpleScannedItemHandler.class);
    private static final SimpleScannedItemHandler instance = new SimpleScannedItemHandler();
    private final Map<Class<?>, Class<?>> scannedClasses = new HashMap();
    private final Map<String, Class<?>> scannedClassesById = new HashMap();
    private final Map<String, Set<Method>> observers = new HashMap<String, Set<Method>>();

    public static SimpleScannedItemHandler instance() {
        return instance;
    }

    static SimpleScannedItemHandler instance(boolean reset) {
        SimpleScannedItemHandler.instance.scannedClasses.clear();
        SimpleScannedItemHandler.instance.observers.clear();
        return instance;
    }

    private SimpleScannedItemHandler() {
    }

    @Override
    public boolean handleMarkerItem(ScannedItem item) {
        return false;
    }

    @Override
    public void handleScannedItem(ScannedItem item) {
        if ("class".equals(item.getExtension()) && item.getName().indexOf(36) == -1) {
            try {
                Class<?> clazz = item.loadAsClass();
                if (clazz.isAnnotationPresent(RemoteDestination.class)) {
                    this.scannedClasses.put(clazz, clazz);
                    if (clazz.getAnnotation(RemoteDestination.class).id().length() > 0) {
                        this.scannedClassesById.put(clazz.getAnnotation(RemoteDestination.class).id(), clazz);
                    }
                }
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    if (!clazz2.isAnnotationPresent(RemoteDestination.class)) continue;
                    this.scannedClasses.put(clazz2, clazz);
                    if (clazz2.getAnnotation(RemoteDestination.class).id().length() <= 0) continue;
                    this.scannedClassesById.put(clazz2.getAnnotation(RemoteDestination.class).id(), clazz);
                }
                for (GenericDeclaration genericDeclaration : clazz.getMethods()) {
                    if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(Observer.class)) continue;
                    Observer o = ((Method)genericDeclaration).getAnnotation(Observer.class);
                    Set<Method> methods = this.observers.get(o.value());
                    if (methods == null) {
                        methods = new HashSet<Method>();
                        this.observers.put(o.value(), methods);
                    }
                    methods.add((Method)genericDeclaration);
                }
            }
            catch (Throwable e) {
                log.debug(e, "Could not introspect scanned item: %s", item);
            }
        }
    }

    public Map<Class<?>, Class<?>> getScannedClasses() {
        return this.scannedClasses;
    }

    public Map<String, Class<?>> getScannedClassesById() {
        return this.scannedClassesById;
    }

    public Map<String, Set<Method>> getObservers() {
        return this.observers;
    }
}

