/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.simple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideServiceContext;
import org.granite.tide.annotations.BypassTideMerge;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.data.DataContext;
import org.granite.tide.invocation.ContextUpdate;
import org.granite.tide.invocation.InvocationResult;
import org.granite.tide.simple.SimpleIdentity;
import org.granite.tide.simple.SimpleScannedItemHandler;
import org.granite.tide.util.AbstractContext;
import org.granite.util.TypeUtil;

public class SimpleServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(SimpleServiceContext.class);
    private Map<String, SimpleComponent> cache = new ConcurrentHashMap<String, SimpleComponent>();
    private final SimpleIdentity identity = new SimpleIdentity();

    @Override
    protected AsyncPublisher getAsyncPublisher() {
        return null;
    }

    @Override
    protected TidePersistenceManager getTidePersistenceManager(boolean create) {
        return null;
    }

    @Override
    public Object findComponent(String componentName, Class<?> componentClass, String methodName) {
        if ("identity".equals(componentName)) {
            return this.identity;
        }
        SimpleComponent component = null;
        if (componentName != null) {
            component = this.cache.get(componentName);
        } else {
            for (Map.Entry<String, SimpleComponent> entry : this.cache.entrySet()) {
                if (!entry.getValue().classes.contains(componentClass)) continue;
                component = entry.getValue();
                break;
            }
        }
        if (component != null) {
            return component.instance;
        }
        log.debug(">> New SimpleServiceContext looking up: %s", componentName);
        try {
            SimpleScannedItemHandler itemHandler = SimpleScannedItemHandler.instance();
            Class<?> clazz = null;
            clazz = componentClass != null ? itemHandler.getScannedClasses().get(componentClass) : itemHandler.getScannedClassesById().get(componentName);
            if (clazz == null) {
                return null;
            }
            component = new SimpleComponent();
            component.instance = TypeUtil.newInstance(clazz, Object.class);
            component.classes = new HashSet();
            component.classes.add(clazz);
            this.cache.put(componentName, component);
            return component.instance;
        }
        catch (Exception e) {
            log.error(e, "Component not found %s", componentName);
            throw new ServiceException("Could not lookup for: " + componentName, e);
        }
    }

    @Override
    public Set<Class<?>> findComponentClasses(String componentName, Class<?> componentClass, String methodName) {
        if ("identity".equals(componentName)) {
            HashSet classes = new HashSet(1);
            classes.add(SimpleIdentity.class);
            return classes;
        }
        SimpleComponent component = this.cache.get(componentName);
        if (component == null) {
            this.findComponent(componentName, componentClass, methodName);
        }
        return this.cache.get((Object)componentName).classes;
    }

    @Override
    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName, Class<?> componentClass) {
        DataContext.init();
    }

    @Override
    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName, Class<?> componentClass) {
        Set<Class<?>> componentClasses;
        ArrayList<ContextUpdate> results = new ArrayList<ContextUpdate>();
        DataContext dataContext = DataContext.get();
        Object[][] updates = dataContext != null ? dataContext.getUpdates() : (Object[][])null;
        InvocationResult ires = new InvocationResult(result, results);
        if ((componentName != null || componentClass != null) && this.isBeanAnnotationPresent(componentClasses = this.findComponentClasses(componentName, componentClass, null), context.getMethod().getName(), context.getMethod().getParameterTypes(), BypassTideMerge.class)) {
            ires.setMerge(false);
        }
        ires.setUpdates(updates);
        return ires;
    }

    @Override
    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName, Class<?> componentClass) {
        AbstractContext.remove();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cache = new ConcurrentHashMap<String, SimpleComponent>();
    }

    private static class SimpleComponent {
        public Object instance;
        public Set<Class<?>> classes;

        private SimpleComponent() {
        }
    }
}

