/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.simple;

import flex.messaging.messages.RemotingMessage;
import java.util.Map;
import org.granite.config.flex.Destination;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.scan.ScannedItemHandler;
import org.granite.tide.TideServiceInvoker;
import org.granite.tide.simple.SimpleScannedItemHandler;
import org.granite.tide.simple.SimpleServiceContext;

public class SimpleServiceFactory
extends ServiceFactory {
    public static ScannedItemHandler getScannedItemHandler() {
        return SimpleScannedItemHandler.instance(true);
    }

    @Override
    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Map<String, Object> cache = context.getApplicationMap();
        Destination destination = ((ServicesConfig)context.getServicesConfig()).findDestinationById(messageType, destinationId);
        String key = TideServiceInvoker.class.getName() + '.' + destinationId;
        return this.getServiceInvoker(cache, destination, key);
    }

    private synchronized ServiceInvoker<?> getServiceInvoker(Map<String, Object> cache, Destination destination, String key) {
        TideServiceInvoker<SimpleServiceFactory> invoker = (TideServiceInvoker<SimpleServiceFactory>)cache.get(key);
        if (invoker != null) {
            return invoker;
        }
        SimpleServiceContext tideContext = new SimpleServiceContext();
        invoker = new TideServiceInvoker<SimpleServiceFactory>(destination, this, tideContext);
        cache.put(key, invoker);
        return invoker;
    }
}

