/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContext;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.ITidePersistenceManager;
import org.granite.tide.TideServiceContext;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.data.JTAPersistenceContextManager;
import org.granite.tide.invocation.InvocationResult;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    protected transient ApplicationContext springContext = null;
    private String persistenceManagerBeanName = null;
    private String entityManagerFactoryBeanName = null;
    private static final Logger log = Logger.getLogger(SpringServiceContext.class);

    public SpringServiceContext() throws ServiceException {
        log.debug("Getting spring context from container", new Object[0]);
        this.getSpringContext();
    }

    protected ApplicationContext getSpringContext() {
        if (this.springContext == null) {
            GraniteContext context = GraniteContext.getCurrentInstance();
            ServletContext sc = ((HttpGraniteContext)context).getServletContext();
            this.springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        }
        return this.springContext;
    }

    protected AsyncPublisher getAsyncPublisher() {
        return null;
    }

    public Object findComponent(String componentName) {
        try {
            Object bean = this.getSpringContext().getBean(componentName);
            return bean;
        }
        catch (NoSuchBeanDefinitionException nexc) {
            if (componentName.endsWith("Controller")) {
                try {
                    Object bean = this.getSpringContext().getBean(String.valueOf(componentName.substring(0, 1).toUpperCase()) + componentName.substring(1));
                    return bean;
                }
                catch (NoSuchBeanDefinitionException bean) {
                    // empty catch block
                }
            }
            String msg = "Spring service named '" + componentName + "' does not exist.";
            ServiceException e = new ServiceException(msg, (Throwable)nexc);
            throw e;
        }
        catch (BeansException bexc) {
            String msg = "Unable to create Spring service named '" + componentName + "'";
            ServiceException e = new ServiceException(msg, (Throwable)bexc);
            throw e;
        }
    }

    public Class<?> findComponentClass(String componentName) {
        try {
            Object bean = this.findComponent(componentName);
            return AopUtils.getTargetClass((Object)bean);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Could not get class for component " + componentName, new Object[0]);
            return null;
        }
    }

    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName) {
    }

    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName) {
        InvocationResult ires = new InvocationResult(result);
        return ires;
    }

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName) {
    }

    public void setEntityManagerFactoryBeanName(String beanName) {
        this.entityManagerFactoryBeanName = beanName;
    }

    public void setPersistenceManagerBeanName(String beanName) {
        this.persistenceManagerBeanName = beanName;
    }

    protected ITidePersistenceManager getTidePersistenceManager(boolean create) {
        if (!create) {
            return null;
        }
        if (this.persistenceManagerBeanName == null) {
            String emfBeanName = this.entityManagerFactoryBeanName != null ? this.entityManagerFactoryBeanName : "entityManagerFactory";
            EntityManagerFactory emf = (EntityManagerFactory)this.findComponent(emfBeanName);
            return new JTAPersistenceContextManager(emf);
        }
        return (ITidePersistenceManager)this.findComponent(this.persistenceManagerBeanName);
    }
}

