/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring.security;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.granite.tide.annotations.TideEnabled;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TideEnabled
public class Identity {
    public boolean ifNotGranted(String authorities) {
        Collection<GrantedAuthority> granted = this.getPrincipalAuthorities();
        Set<GrantedAuthority> grantedCopy = this.retainAll(granted, this.parseAuthoritiesString(authorities));
        return grantedCopy.isEmpty();
    }

    public boolean ifAllGranted(String authorities) {
        Collection<GrantedAuthority> granted = this.getPrincipalAuthorities();
        return granted.containsAll(this.parseAuthoritiesString(authorities));
    }

    public boolean ifAnyGranted(String authorities) {
        Collection<GrantedAuthority> granted = this.getPrincipalAuthorities();
        Set<GrantedAuthority> grantedCopy = this.retainAll(granted, this.parseAuthoritiesString(authorities));
        return !grantedCopy.isEmpty();
    }

    private Collection<GrantedAuthority> getPrincipalAuthorities() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication.getAuthorities() == null) {
            return Collections.emptyList();
        }
        return Arrays.asList((Object[])authentication.getAuthorities());
    }

    private Set<GrantedAuthority> parseAuthoritiesString(String authorizationsString) {
        HashSet<GrantedAuthority> requiredAuthorities = new HashSet<GrantedAuthority>();
        String[] authorities = StringUtils.commaDelimitedListToStringArray((String)authorizationsString);
        int i = 0;
        while (i < authorities.length) {
            String authority = authorities[i];
            String role = authority.trim();
            role = StringUtils.deleteAny((String)role, (String)"\t\n\r\f");
            requiredAuthorities.add((GrantedAuthority)new GrantedAuthorityImpl(role));
            ++i;
        }
        return requiredAuthorities;
    }

    private Set<GrantedAuthority> retainAll(Collection<GrantedAuthority> granted, Set<GrantedAuthority> required) {
        Set<String> grantedRoles = this.authoritiesToRoles(granted);
        Set<String> requiredRoles = this.authoritiesToRoles(required);
        grantedRoles.retainAll(requiredRoles);
        return this.rolesToAuthorities(grantedRoles, granted);
    }

    private Set<String> authoritiesToRoles(Collection<GrantedAuthority> c) {
        HashSet<String> roles = new HashSet<String>();
        for (GrantedAuthority authority : c) {
            if (authority.getAuthority() == null) continue;
            roles.add(authority.getAuthority());
        }
        return roles;
    }

    private Set<GrantedAuthority> rolesToAuthorities(Set<String> grantedRoles, Collection<GrantedAuthority> granted) {
        HashSet<GrantedAuthority> target = new HashSet<GrantedAuthority>();
        block0: for (String role : grantedRoles) {
            for (GrantedAuthority authority : granted) {
                if (!authority.getAuthority().equals(role)) continue;
                target.add(authority);
                continue block0;
            }
        }
        return target;
    }
}

