/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring;

import flex.messaging.messages.RemotingMessage;
import javax.servlet.ServletContext;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.service.SimpleServiceFactory;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.spring.SpringServiceInvoker;
import org.granite.util.XMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringServiceFactory
extends SimpleServiceFactory {
    private static final long serialVersionUID = 1L;
    private ApplicationContext springContext = null;

    public void configure(XMap properties) throws ServiceException {
        super.configure(properties);
        GraniteContext context = GraniteContext.getCurrentInstance();
        ServletContext sc = ((HttpGraniteContext)context).getServletContext();
        this.springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
    }

    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        if (destination == null) {
            throw new ServiceException("No matching destination: " + destinationId);
        }
        String beanName = destination.getProperties().get("source");
        try {
            Object bean = this.springContext.getBean(beanName);
            return new SpringServiceInvoker(destination, this, bean);
        }
        catch (NoSuchBeanDefinitionException nexc) {
            String msg = "Spring service named '" + beanName + "' does not exist.";
            ServiceException e = new ServiceException(msg, (Throwable)nexc);
            throw e;
        }
        catch (BeansException bexc) {
            String msg = "Unable to create Spring service named '" + beanName + "'";
            ServiceException e = new ServiceException(msg, (Throwable)bexc);
            throw e;
        }
    }

    public String toString() {
        return this.toString("\n  springContext: " + this.springContext);
    }
}

