/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.spring.SpringValidationException;
import org.granite.tide.validators.InvalidValue;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringValidationExceptionConverter
implements ExceptionConverter {
    public static final String VALIDATION_FAILED = "Validation.Failed";

    public boolean accepts(Throwable t) {
        return t.getClass().equals(SpringValidationException.class);
    }

    public ServiceException convert(Throwable t, String detail, Map<String, Object> extendedData) {
        Errors errors = ((SpringValidationException)t).getErrors();
        extendedData.put("invalidValues", SpringValidationExceptionConverter.convertErrors(errors));
        ServiceException se = new ServiceException(VALIDATION_FAILED, t.getMessage(), detail, t);
        se.getExtendedData().putAll(extendedData);
        return se;
    }

    public static InvalidValue[] convertErrors(Errors errors) {
        Object bean = null;
        GraniteContext context = GraniteContext.getCurrentInstance();
        ServletContext sc = ((HttpGraniteContext)context).getServletContext();
        WebApplicationContext springContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc);
        BindingResult bindingResult = null;
        if (errors instanceof BindingResult) {
            bindingResult = (BindingResult)errors;
            bean = bindingResult.getTarget();
        }
        InvalidValue[] converted = new InvalidValue[errors.getErrorCount()];
        List allErrors = errors.getAllErrors();
        int i = 0;
        for (ObjectError error : allErrors) {
            if (error instanceof FieldError) {
                FieldError ferror = (FieldError)error;
                converted[i++] = new InvalidValue(bean != null ? bean : ferror.getObjectName(), ferror.getField(), ferror.getRejectedValue(), springContext.getMessage((MessageSourceResolvable)ferror, Locale.FRENCH));
                continue;
            }
            converted[i++] = new InvalidValue(bean != null ? bean : error.getObjectName(), null, null, springContext.getMessage((MessageSourceResolvable)error, Locale.FRENCH));
        }
        return converted;
    }
}

