/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.service.tide.TideComponentInstanceOfMatcher;
import org.granite.messaging.service.tide.TideComponentNameMatcher;
import org.granite.messaging.service.tide.TideComponentTypeMatcher;
import org.granite.messaging.webapp.AMFEndpoint;
import org.granite.spring.SpringGraniteConfig;
import org.granite.util.XMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexFilter
implements InitializingBean,
ApplicationContextAware,
ServletContextAware,
HandlerAdapter {
    private static final Logger log = Logger.getLogger(FlexFilter.class);
    private ApplicationContext context = null;
    private ServletContext servletContext = null;
    private GraniteConfig graniteConfig = null;
    private ServicesConfig servicesConfig = null;
    private List<String> tideRoles = null;
    private List<String> tideAnnotations = null;
    private List<String> tideInterfaces = null;
    private List<String> tideNames = null;
    private List<String> tideTypes = null;
    private List<Class<? extends ExceptionConverter>> exceptionConverters = null;
    private AMF3MessageInterceptor amf3MessageInterceptor;
    private boolean tide = false;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setServletContext(ServletContext servletContext) throws BeansException {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() {
        Service service;
        Factory factory;
        SpringGraniteConfig springGraniteConfig = (SpringGraniteConfig)((Object)this.context.getBeansOfType(SpringGraniteConfig.class).values().iterator().next());
        this.graniteConfig = springGraniteConfig.getGraniteConfig();
        Map securityServices = this.context.getBeansOfType(SecurityService.class);
        if (securityServices.size() > 1) {
            log.error("More than one Security Service bean defined", new Object[0]);
        } else if (!securityServices.isEmpty()) {
            log.error("Security Service bean " + (String)securityServices.keySet().iterator().next() + " selected", new Object[0]);
            SecurityService securityService = (SecurityService)securityServices.values().iterator().next();
            this.graniteConfig.setSecurityService(securityService);
        }
        if (this.tideAnnotations != null) {
            for (String string : this.tideAnnotations) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentAnnotatedWithMatcher(string, false));
                    log.debug("Enabled components annotated with {0} for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component annotation {0}", new Object[]{string});
                }
            }
        }
        if (this.tideInterfaces != null) {
            for (String string : this.tideInterfaces) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentInstanceOfMatcher(string, false));
                    log.debug("Enabled components extending {0} for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component interface {0}", new Object[]{string});
                }
            }
        }
        if (this.tideNames != null) {
            for (String string : this.tideNames) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentNameMatcher(string, false));
                    log.debug("Enabled components named like {0} for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component name {0}", new Object[]{string});
                }
            }
        }
        if (this.tideTypes != null) {
            for (String string : this.tideTypes) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentTypeMatcher(string, false));
                    log.debug("Enabled components with type {0} for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component type {0}", new Object[]{string});
                }
            }
        }
        if (this.exceptionConverters != null) {
            for (Class clazz : this.exceptionConverters) {
                this.graniteConfig.registerExceptionConverter(clazz);
                log.debug("Registered exception converter {0}", new Object[]{clazz});
            }
        }
        if (this.amf3MessageInterceptor != null) {
            this.graniteConfig.setAmf3MessageInterceptor(this.amf3MessageInterceptor);
        }
        this.servicesConfig = springGraniteConfig.getServicesConfig();
        Channel channel = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
        this.servicesConfig.addChannel(channel);
        if (this.tide) {
            Destination destination;
            factory = this.servicesConfig.findFactoryById("tide-spring-factory");
            if (factory == null) {
                factory = new Factory("tide-spring-factory", "org.granite.tide.spring.SpringServiceFactory", new XMap());
                this.servicesConfig.addFactory(factory);
            }
            if ((service = this.servicesConfig.findServiceById("granite-service")) == null) {
                service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap());
            }
            if ((destination = this.servicesConfig.findDestinationById("flex.messaging.services.RemotingService", "spring")) == null) {
                ArrayList<String> channelIds = new ArrayList<String>();
                channelIds.add("graniteamf");
                destination = new Destination("spring", channelIds, new XMap(), this.tideRoles, null, null);
                destination.getProperties().put("factory", factory.getId());
                service.getDestinations().put(destination.getId(), destination);
                this.servicesConfig.addService(service);
            }
            log.info("Registered Tide/Spring service factory and destination", new Object[0]);
        } else {
            factory = this.servicesConfig.findFactoryById("spring-factory");
            if (factory == null) {
                factory = new Factory("spring-factory", "org.granite.spring.SpringServiceFactory", new XMap());
                this.servicesConfig.addFactory(factory);
            }
            if ((service = this.servicesConfig.findServiceById("granite-service")) == null) {
                service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap());
                this.servicesConfig.addService(service);
            }
            this.servicesConfig.scan(null);
            log.info("Registered Spring service factory", new Object[0]);
        }
    }

    public void setTideRoles(List<String> tideRoles) {
        this.tideRoles = tideRoles;
    }

    public void setTideAnnotations(List<String> tideAnnotations) {
        this.tideAnnotations = tideAnnotations;
    }

    public void setTideInterfaces(List<String> tideInterfaces) {
        this.tideInterfaces = tideInterfaces;
    }

    public void setTideNames(List<String> tideNames) {
        this.tideNames = tideNames;
    }

    public void setTideTypes(List<String> tideTypes) {
        this.tideTypes = tideTypes;
    }

    public void setExceptionConverters(List<Class<? extends ExceptionConverter>> exceptionConverters) {
        this.exceptionConverters = exceptionConverters;
    }

    public void setAmf3MessageInterceptor(AMF3MessageInterceptor amf3MessageInterceptor) {
        this.amf3MessageInterceptor = amf3MessageInterceptor;
    }

    public void setTide(boolean tide) {
        this.tide = tide;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        AMFEndpoint.service((GraniteConfig)this.graniteConfig, (ServicesConfig)this.servicesConfig, (ServletContext)this.servletContext, (HttpServletRequest)request, (HttpServletResponse)response);
        return null;
    }

    public boolean supports(Object handler) {
        return handler instanceof FlexFilter;
    }
}

