/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import org.granite.logging.Logger;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideTransactionManager;
import org.granite.tide.data.AbstractTidePersistenceManager;
import org.granite.tide.data.JPAPersistenceManager;
import org.granite.tide.data.NoPersistenceManager;
import org.granite.tide.spring.SpringTransactionManager;
import org.granite.util.ClassUtil;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringPersistenceManager
implements TidePersistenceManager {
    private static final Logger log = Logger.getLogger(SpringPersistenceManager.class);
    private TidePersistenceManager pm;

    public SpringPersistenceManager(PlatformTransactionManager transactionManager) {
        SpringTransactionManager tm = new SpringTransactionManager(transactionManager);
        if (transactionManager instanceof HibernateTransactionManager) {
            try {
                Object sf = transactionManager.getClass().getMethod("getSessionFactory", new Class[0]).invoke((Object)transactionManager, new Object[0]);
                this.pm = (TidePersistenceManager)ClassUtil.newInstance((String)"org.granite.tide.hibernate.HibernatePersistenceManager", (Class[])new Class[]{SessionFactory.class, TideTransactionManager.class}, (Object[])new Object[]{sf, tm});
            }
            catch (Exception e) {
                log.error("Could not setup Hibernate persistence manager, lazy-loading disabled. Check that granite-hibernate.jar is present in the classpath.", new Object[0]);
                this.pm = new NoPersistenceManager();
            }
        } else if (transactionManager instanceof JpaTransactionManager) {
            this.pm = new JPAPersistenceManager(((JpaTransactionManager)transactionManager).getEntityManagerFactory(), (TideTransactionManager)tm);
        } else {
            log.error("Unsupported Spring TransactionManager, lazy-loading disabled", new Object[0]);
            this.pm = new NoPersistenceManager();
        }
    }

    public Object attachEntity(Object entity, String[] propertyNames) {
        if (this.pm instanceof AbstractTidePersistenceManager) {
            return ((AbstractTidePersistenceManager)this.pm).attachEntity((TidePersistenceManager)this, entity, propertyNames);
        }
        return this.pm.attachEntity(entity, propertyNames);
    }
}

