/*
  GRANITE DATA SERVICES
  Copyright (C) 2007-2009 ADEQUATE SYSTEMS SARL

  This file is part of Granite Data Services.

  Granite Data Services is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 3 of the License, or (at your
  option) any later version.

  Granite Data Services is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

package org.granite.spring;

import java.io.IOException;

import javax.servlet.ServletContext;

import org.granite.config.AbstractFrameworkGraniteConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;
import org.xml.sax.SAXException;


public class SpringGraniteConfig extends AbstractFrameworkGraniteConfig implements InitializingBean, ServletContextAware
{

    private ServletContext servletContext = null;


    public void afterPropertiesSet() throws IOException, SAXException
    {
        init( servletContext, "org/granite/spring/granite-config-spring.xml" );
    }

    public void setServletContext( ServletContext servletContext )
    {
        this.servletContext = servletContext;
    }
}
