/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.webapp.AMFEndpoint;
import org.granite.spring.SpringGraniteConfig;
import org.granite.util.XMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexFilter
implements InitializingBean,
ApplicationContextAware,
ServletContextAware,
HandlerAdapter {
    private static final Logger log = Logger.getLogger(FlexFilter.class);
    private ApplicationContext context = null;
    private ServletContext servletContext = null;
    private GraniteConfig graniteConfig = null;
    private ServicesConfig servicesConfig = null;
    private List<String> tideRoles = null;
    private List<String> tideAnnotations = null;
    private List<Class<? extends ExceptionConverter>> exceptionConverters = null;
    private AMF3MessageInterceptor amf3MessageInterceptor;
    private boolean tide = false;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setServletContext(ServletContext servletContext) throws BeansException {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() {
        SpringGraniteConfig springGraniteConfig = (SpringGraniteConfig)((Object)this.context.getBeansOfType(SpringGraniteConfig.class).values().iterator().next());
        this.graniteConfig = springGraniteConfig.getGraniteConfig();
        if (this.tideAnnotations != null) {
            for (String string : this.tideAnnotations) {
                try {
                    this.graniteConfig.getTideComponentMatchers().add(new TideComponentAnnotatedWithMatcher(string, false));
                    log.debug("Enabled components annotated with {0} for Tide remoting", new Object[]{string});
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not add tide-component annotation {0}", new Object[]{string});
                }
            }
        }
        if (this.exceptionConverters != null) {
            for (Class clazz : this.exceptionConverters) {
                this.graniteConfig.registerExceptionConverter(clazz);
                log.debug("Registered exception converter {0}", new Object[]{clazz});
            }
        }
        if (this.amf3MessageInterceptor != null) {
            this.graniteConfig.setAmf3MessageInterceptor(this.amf3MessageInterceptor);
        }
        this.servicesConfig = springGraniteConfig.getServicesConfig();
        Channel channel = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
        this.servicesConfig.addChannel(channel);
        if (this.tide) {
            Factory factory = new Factory("tide-spring-factory", "org.granite.tide.spring.SpringServiceFactory", new XMap());
            this.servicesConfig.addFactory(factory);
            Service service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap());
            ArrayList<String> channelIds = new ArrayList<String>();
            channelIds.add("graniteamf");
            Destination destination = new Destination("spring", channelIds, new XMap(), this.tideRoles, null, null);
            destination.getProperties().put("factory", "tide-spring-factory");
            service.getDestinations().put("spring", destination);
            this.servicesConfig.addService(service);
            log.info("Registered Tide/Spring service factory and destination", new Object[0]);
        } else {
            Factory factory = new Factory("spring-factory", "org.granite.spring.SpringServiceFactory", new XMap());
            this.servicesConfig.addFactory(factory);
            Service service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap());
            this.servicesConfig.addService(service);
            this.servicesConfig.scan(null);
            log.info("Registered Spring service factory", new Object[0]);
        }
    }

    public void setTideRoles(List<String> tideRoles) {
        this.tideRoles = tideRoles;
    }

    public void setTideAnnotations(List<String> tideAnnotations) {
        this.tideAnnotations = tideAnnotations;
    }

    public void setExceptionConverters(List<Class<? extends ExceptionConverter>> exceptionConverters) {
        this.exceptionConverters = exceptionConverters;
    }

    public void setAmf3MessageInterceptor(AMF3MessageInterceptor amf3MessageInterceptor) {
        this.amf3MessageInterceptor = amf3MessageInterceptor;
    }

    public void setTide(boolean tide) {
        this.tide = tide;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        AMFEndpoint.service((GraniteConfig)this.graniteConfig, (ServicesConfig)this.servicesConfig, (ServletContext)this.servletContext, (HttpServletRequest)request, (HttpServletResponse)response);
        return null;
    }

    public boolean supports(Object handler) {
        return handler instanceof FlexFilter;
    }
}

