/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.servlet.ServletContext;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideServiceContext;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.data.DataContext;
import org.granite.tide.invocation.InvocationResult;
import org.granite.tide.spring.SpringPersistenceManager;
import org.granite.util.ClassUtil;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    protected transient ApplicationContext springContext = null;
    private String persistenceManagerBeanName = null;
    private String entityManagerFactoryBeanName = null;
    private static final Logger log = Logger.getLogger(SpringServiceContext.class);

    public SpringServiceContext() throws ServiceException {
        log.debug("Getting spring context from container", new Object[0]);
        this.getSpringContext();
    }

    protected ApplicationContext getSpringContext() {
        if (this.springContext == null) {
            GraniteContext context = GraniteContext.getCurrentInstance();
            ServletContext sc = ((HttpGraniteContext)context).getServletContext();
            this.springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        }
        return this.springContext;
    }

    protected AsyncPublisher getAsyncPublisher() {
        return null;
    }

    public Object findComponent(String componentName, Class<?> componentClass) {
        Object bean = null;
        String key = "__TIDE_COMPONENT__" + componentName;
        GraniteContext context = GraniteContext.getCurrentInstance();
        if (context != null && (bean = (Object)context.getRequestMap().get(key)) != null) {
            return bean;
        }
        try {
            bean = this.getSpringContext().getBean(componentName);
            if (context != null) {
                context.getRequestMap().put(key, bean);
            }
            return bean;
        }
        catch (NoSuchBeanDefinitionException nexc) {
            if (componentName.endsWith("Controller")) {
                try {
                    int idx = componentName.lastIndexOf(".");
                    String controllerName = idx > 0 ? componentName.substring(0, idx + 1) + componentName.substring(idx + 1, idx + 2).toUpperCase() + componentName.substring(idx + 2) : componentName.substring(0, 1).toUpperCase() + componentName.substring(1);
                    bean = this.getSpringContext().getBean(controllerName);
                    if (context != null) {
                        context.getRequestMap().put(key, bean);
                    }
                    return bean;
                }
                catch (NoSuchBeanDefinitionException nexc2) {
                    // empty catch block
                }
            }
            String msg = "Spring service named '" + componentName + "' does not exist.";
            ServiceException e = new ServiceException(msg, (Throwable)nexc);
            throw e;
        }
        catch (BeansException bexc) {
            String msg = "Unable to create Spring service named '" + componentName + "'";
            ServiceException e = new ServiceException(msg, (Throwable)bexc);
            throw e;
        }
    }

    public Set<Class<?>> findComponentClasses(String componentName, Class<?> componentClass) {
        String key = "__TIDE_COMPONENT_CLASS__" + componentName;
        HashSet classes = null;
        GraniteContext context = GraniteContext.getCurrentInstance();
        if (context != null && (classes = (HashSet)context.getRequestMap().get(key)) != null) {
            return classes;
        }
        try {
            Object bean = this.findComponent(componentName, componentClass);
            classes = new HashSet();
            for (Class<?> i : bean.getClass().getInterfaces()) {
                classes.add(i);
            }
            while (bean instanceof Advised) {
                bean = ((Advised)bean).getTargetSource().getTarget();
            }
            classes.add(AopUtils.getTargetClass((Object)bean));
            if (context != null) {
                context.getRequestMap().put(key, classes);
            }
            return classes;
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Could not get class for component " + componentName, new Object[0]);
            return null;
        }
    }

    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName, Class<?> componentClass) {
    }

    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName, Class<?> componentClass) {
        List results = null;
        DataContext dataContext = DataContext.get();
        Set dataUpdates = dataContext != null ? dataContext.getDataUpdates() : null;
        Object[][] updates = null;
        if (dataUpdates != null && !dataUpdates.isEmpty()) {
            updates = (Object[][])dataUpdates.toArray((T[])new Object[dataUpdates.size()][]);
        }
        InvocationResult ires = new InvocationResult(result, results);
        ires.setUpdates(updates);
        return ires;
    }

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName, Class<?> componentClass) {
    }

    public void setEntityManagerFactoryBeanName(String beanName) {
        this.entityManagerFactoryBeanName = beanName;
    }

    public void setPersistenceManagerBeanName(String beanName) {
        this.persistenceManagerBeanName = beanName;
    }

    protected TidePersistenceManager getTidePersistenceManager(boolean create) {
        if (!create) {
            return null;
        }
        if (this.persistenceManagerBeanName == null) {
            if (this.entityManagerFactoryBeanName == null) {
                Map pms = this.springContext.getBeansOfType(TidePersistenceManager.class);
                if (pms.size() > 1) {
                    throw new RuntimeException("More than one Tide persistence managers defined");
                }
                if (pms.size() == 1) {
                    return (TidePersistenceManager)pms.values().iterator().next();
                }
                Map tms = this.springContext.getBeansOfType(PlatformTransactionManager.class);
                if (tms.size() == 1) {
                    return new SpringPersistenceManager((PlatformTransactionManager)tms.values().iterator().next());
                }
            }
            String emfBeanName = this.entityManagerFactoryBeanName != null ? this.entityManagerFactoryBeanName : "entityManagerFactory";
            Object emf = this.findComponent(emfBeanName, null);
            try {
                Constructor<?>[] cs;
                Class pcmClass = ClassUtil.forName((String)"org.granite.tide.data.JPAPersistenceManager");
                for (Constructor<?> c : cs = pcmClass.getConstructors()) {
                    if (c.getParameterTypes().length != 1 || !EntityManagerFactory.class.isAssignableFrom(c.getParameterTypes()[0])) continue;
                    return (TidePersistenceManager)c.newInstance(emf);
                }
                throw new RuntimeException("Default Tide persistence manager not found");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create default Tide persistence manager", e);
            }
        }
        return (TidePersistenceManager)this.findComponent(this.persistenceManagerBeanName, null);
    }
}

