/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import flex.messaging.messages.RemotingMessage;
import java.util.Map;
import javax.servlet.ServletContext;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ExtendedServiceExceptionHandler;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.TideServiceContext;
import org.granite.tide.TideServiceInvoker;
import org.granite.tide.data.PersistenceExceptionConverter;
import org.granite.tide.spring.SpringServiceContext;
import org.granite.util.ClassUtil;
import org.granite.util.XMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringServiceFactory
extends ServiceFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(SpringServiceFactory.class);
    public static final String PERSISTENCE_MANAGER_BEAN_NAME = "persistence-manager-bean-name";
    private String lookup = null;

    public String getLookup() {
        return this.lookup;
    }

    public void configure(XMap properties) throws ServiceException {
        String sServiceExceptionHandler = properties.get("service-exception-handler");
        if (sServiceExceptionHandler == null) {
            XMap props = new XMap(properties);
            props.put("service-exception-handler", ExtendedServiceExceptionHandler.class.getName());
            super.configure(props);
        } else {
            super.configure(properties);
        }
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        try {
            graniteContext.getGraniteConfig().registerExceptionConverter(PersistenceExceptionConverter.class);
        }
        catch (Throwable t) {
            log.error("Could not register exception converter", new Object[]{t});
        }
        this.lookup = properties.get("lookup");
    }

    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Map cache = context.getSessionMap();
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        if (destination == null) {
            throw new ServiceException("No matching destination: " + destinationId);
        }
        String key = TideServiceInvoker.class.getName() + '.' + destinationId;
        return this.getServiceInvoker(cache, destination, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceInvoker<?> getServiceInvoker(Map<String, Object> cache, Destination destination, String key) {
        GraniteContext context = GraniteContext.getCurrentInstance();
        Object object = context.getSessionLock();
        synchronized (object) {
            ServiceInvoker invoker = (ServiceInvoker)cache.get(key);
            if (invoker == null) {
                SpringServiceContext tideContext = null;
                ServletContext sc = ((HttpGraniteContext)context).getServletContext();
                WebApplicationContext springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
                Map beans = springContext.getBeansOfType(SpringServiceContext.class);
                if (beans.size() > 1) {
                    throw new RuntimeException("More than one SpringServiceContext bean found");
                }
                if (beans.size() == 1) {
                    tideContext = (SpringServiceContext)((Object)beans.values().iterator().next());
                } else {
                    String className = "org.granite.tide.spring.SpringMVCServiceContext";
                    try {
                        Class clazz = ClassUtil.forName((String)className, SpringServiceContext.class);
                        tideContext = (SpringServiceContext)((Object)clazz.newInstance());
                    }
                    catch (Exception e) {
                        tideContext = new SpringServiceContext();
                    }
                }
                String beanName = destination.getProperties().get(PERSISTENCE_MANAGER_BEAN_NAME);
                tideContext.setPersistenceManagerBeanName(beanName);
                invoker = new TideServiceInvoker(destination, (ServiceFactory)this, (TideServiceContext)tideContext);
                cache.put(key, invoker);
            }
            return invoker;
        }
    }
}

