/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class TideIdentityBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String objectIdentityRetrievalStrategy;
        String sidRetrievalStrategy;
        element.setAttribute("id", "identity");
        builder.setRole(2);
        String aclService = element.getAttribute("acl-service");
        if (aclService != null && aclService.trim().length() > 0) {
            builder.addPropertyReference("aclService", aclService);
        }
        if ((sidRetrievalStrategy = element.getAttribute("sid-retrieval-strategy")) != null && sidRetrievalStrategy.trim().length() > 0) {
            builder.addPropertyReference("sidRetrievalStrategy", sidRetrievalStrategy);
        }
        if ((objectIdentityRetrievalStrategy = element.getAttribute("object-identity-retrieval-strategy")) != null && objectIdentityRetrievalStrategy.trim().length() > 0) {
            builder.addPropertyReference("objectIdentityRetrievalStrategy", objectIdentityRetrievalStrategy);
        }
    }

    protected String getBeanClassName(Element element) {
        String aclService = element.getAttribute("acl-service");
        return "org.granite.tide.spring.security." + (aclService != null && aclService.trim().length() > 0 ? "AclIdentity" : "Identity");
    }

    static void mapOptionalAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String ... attrs) {
        for (String attr : attrs) {
            String propertyName;
            String value = element.getAttribute(attr);
            if (!StringUtils.hasText((String)value) || !TideIdentityBeanDefinitionParser.validateProperty(element, parserContext, propertyName = Conventions.attributeNameToPropertyName((String)attr), attr)) continue;
            builder.addPropertyValue(propertyName, (Object)value);
        }
    }

    private static boolean validateProperty(Element element, ParserContext parserContext, String propertyName, String attr) {
        if (!StringUtils.hasText((String)propertyName)) {
            parserContext.getReaderContext().error("Illegal property name trying to convert from attribute '" + attr + "' : cannot be null or empty.", parserContext.extractSource((Object)element));
            return false;
        }
        return true;
    }
}

