/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import org.granite.logging.Logger;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class TidePersistenceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final Logger log = Logger.getLogger(TidePersistenceBeanDefinitionParser.class);

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setAutowireMode(3);
        if (!StringUtils.hasText((String)element.getAttribute("id"))) {
            element.setAttribute("id", "org.granite.tide.spring.SpringPersistenceManager");
        }
        builder.setScope("request");
        builder.setRole(2);
        Element transactionManager = DomUtils.getChildElementByTagName((Element)element, (String)"transaction-manager");
        if (transactionManager != null) {
            builder.addConstructorArgReference(transactionManager.getTextContent());
        } else {
            log.info("No transaction-manager specified, use 'transactionManager' default", new Object[0]);
            builder.addConstructorArgReference("transactionManager");
        }
    }

    protected String getBeanClassName(Element element) {
        return "org.granite.tide.spring.SpringPersistenceManager";
    }
}

