/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.AbstractSpringSecurityInterceptor;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.security.AbstractAuthenticationManager;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurityService
extends AbstractSecurityService {
    private static final Logger log = Logger.getLogger(SpringSecurityService.class);
    private static final String FILTER_APPLIED = "__spring_security_filterSecurityInterceptor_filterApplied";
    private AbstractSpringSecurityInterceptor securityInterceptor = null;

    public SpringSecurityService() {
        log.debug("Starting Spring Security Service!", new Object[0]);
    }

    public void configure(Map<String, String> params) {
        log.debug("Configuring with parameters (NOOP) %s: ", new Object[]{params});
    }

    public void setSecurityInterceptor(AbstractSpringSecurityInterceptor securityInterceptor) {
        this.securityInterceptor = securityInterceptor;
    }

    public void login(Object credentials) {
        List<String> decodedCredentials = Arrays.asList(this.decodeBase64Credentials(credentials));
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = context.getRequest();
        String user = decodedCredentials.get(0);
        String password = decodedCredentials.get(1);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)password);
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)httpRequest.getSession().getServletContext());
        if (ctx != null) {
            AbstractAuthenticationManager authenticationManager = (AbstractAuthenticationManager)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)ctx, AbstractAuthenticationManager.class);
            try {
                Authentication authentication = authenticationManager.authenticate((Authentication)auth);
                SecurityContext securityContext = SecurityContextHolder.getContext();
                securityContext.setAuthentication(authentication);
                SecurityContextHolder.setContext((SecurityContext)securityContext);
                this.saveSecurityContextInSession(securityContext, 0);
            }
            catch (BadCredentialsException e) {
                throw SecurityServiceException.newInvalidCredentialsException((String)e.getMessage());
            }
        }
        log.debug("Logged In!", new Object[0]);
    }

    public Object authorize(AbstractSecurityContext context) throws Exception {
        log.debug("Authorize: %s", new Object[]{context});
        log.debug("Is %s secured? %b", new Object[]{context.getDestination().getId(), context.getDestination().isSecured()});
        this.startAuthorization(context);
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        SecurityContext securityContextBefore = null;
        int securityContextHashBefore = 0;
        if (graniteContext.getRequest().getAttribute(FILTER_APPLIED) == null) {
            securityContextBefore = this.loadSecurityContextFromSession();
            if (securityContextBefore == null) {
                securityContextBefore = SecurityContextHolder.getContext();
            } else {
                securityContextHashBefore = securityContextBefore.hashCode();
            }
            SecurityContextHolder.setContext((SecurityContext)securityContextBefore);
            authentication = securityContextBefore.getAuthentication();
        }
        if (context.getDestination().isSecured()) {
            if (!this.isAuthenticated(authentication) || authentication instanceof AnonymousAuthenticationToken) {
                log.debug("Is not authenticated!", new Object[0]);
                throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
            }
            if (!this.userCanAccessService(context, authentication)) {
                log.debug("Access denied for: %s", new Object[]{authentication.getName()});
                throw SecurityServiceException.newAccessDeniedException((String)"User not in required role");
            }
        }
        try {
            Object returnedObject;
            Object object = returnedObject = this.securityInterceptor != null ? this.securityInterceptor.invoke(context) : this.endAuthorization(context);
            return object;
        }
        catch (AccessDeniedException e) {
            throw SecurityServiceException.newAccessDeniedException((String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.handleAuthorizationExceptions(e);
            throw e;
        }
        finally {
            if (graniteContext.getRequest().getAttribute(FILTER_APPLIED) == null) {
                SecurityContext securityContextAfter = SecurityContextHolder.getContext();
                SecurityContextHolder.clearContext();
                this.saveSecurityContextInSession(securityContextAfter, securityContextHashBefore);
            }
        }
    }

    public void logout() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpSession session = context.getSession(false);
        if (session != null && session.getAttribute("SPRING_SECURITY_CONTEXT") != null) {
            session.invalidate();
        }
        SecurityContextHolder.clearContext();
    }

    protected boolean isUserInRole(Authentication authentication, String role) {
        GrantedAuthority[] grantedAuthorityArray = authentication.getAuthorities();
        int n = grantedAuthorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            GrantedAuthority ga = grantedAuthorityArray[n2];
            if (ga.getAuthority().matches(role)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isAuthenticated(Authentication authentication) {
        return authentication != null && authentication.isAuthenticated();
    }

    protected boolean userCanAccessService(AbstractSecurityContext context, Authentication authentication) {
        log.debug("Is authenticated as: %s", new Object[]{authentication.getName()});
        for (String role : context.getDestination().getRoles()) {
            if (this.isUserInRole(authentication, role)) {
                log.debug("Allowed access to %s in role %s", new Object[]{authentication.getName(), role});
                return true;
            }
            log.debug("Access denied for %s not in role %s", new Object[]{authentication.getName(), role});
        }
        return false;
    }

    protected SecurityContext loadSecurityContextFromSession() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest request = context.getRequest();
        return (SecurityContext)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT");
    }

    protected void saveSecurityContextInSession(SecurityContext securityContext, int securityContextHashBefore) {
        if (securityContext.hashCode() != securityContextHashBefore && !(securityContext.getAuthentication() instanceof AnonymousAuthenticationToken)) {
            HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
            HttpServletRequest request = context.getRequest();
            request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)securityContext);
        }
    }

    protected void handleAuthorizationExceptions(InvocationTargetException e) {
        Throwable t = e;
        while (t != null) {
            if (t instanceof SecurityException || t instanceof AccessDeniedException || "javax.ejb.EJBAccessException".equals(t.getClass().getName())) {
                throw SecurityServiceException.newAccessDeniedException((String)t.getMessage());
            }
            t = ((Throwable)t).getCause();
        }
    }
}

