/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import org.granite.config.AbstractFrameworkGraniteConfig;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.SecurityService;
import org.granite.util.ClassUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.xml.sax.SAXException;

public class SpringGraniteConfig
extends AbstractFrameworkGraniteConfig
implements InitializingBean,
ServletContextAware,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(SpringGraniteConfig.class);
    private ServletContext servletContext = null;
    private ApplicationContext applicationContext = null;

    public static boolean isSpringSecurity3Present() {
        try {
            SpringGraniteConfig.class.getClassLoader().loadClass("org.springframework.security.access.AccessDeniedException");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isSpringSecurity2Present() {
        try {
            SpringGraniteConfig.class.getClassLoader().loadClass("org.springframework.security.context.SecurityContext");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void afterPropertiesSet() throws IOException, SAXException {
        this.init(this.servletContext, "org/granite/spring/granite-config-spring.xml");
        if (this.getGraniteConfig().getSecurityService() == null) {
            Map servicesMap = this.applicationContext.getBeansOfType(SecurityService.class);
            if (servicesMap.size() == 1) {
                Map.Entry se = servicesMap.entrySet().iterator().next();
                log.info("Found security service %s in Spring context", new Object[]{se.getKey()});
                this.getGraniteConfig().setSecurityService((SecurityService)se.getValue());
            } else {
                if (servicesMap.size() > 1) {
                    log.warn("Multiple security services found in Spring context, will use default config", new Object[0]);
                }
                try {
                    if (SpringGraniteConfig.isSpringSecurity3Present()) {
                        this.getGraniteConfig().setSecurityService((SecurityService)ClassUtil.newInstance((String)"org.granite.spring.security.SpringSecurity3Service", SecurityService.class));
                    } else if (SpringGraniteConfig.isSpringSecurity2Present()) {
                        this.getGraniteConfig().setSecurityService((SecurityService)ClassUtil.newInstance((String)"org.granite.messaging.service.security.SpringSecurityService", SecurityService.class));
                    }
                }
                catch (Exception e) {
                    throw new IOException("Could not configure Spring Security service");
                }
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

