/*
  GRANITE DATA SERVICES
  Copyright (C) 2007-2009 ADEQUATE SYSTEMS SARL

  This file is part of Granite Data Services.

  Granite Data Services is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  Granite Data Services is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License
  for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; if not, see <http://www.gnu.org/licenses/>.
*/

package org.granite.spring;

import java.io.IOException;

import javax.servlet.ServletContext;

import org.granite.config.AbstractFrameworkGraniteConfig;
import org.granite.messaging.service.security.SecurityService;
import org.granite.util.ClassUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;
import org.xml.sax.SAXException;


public class SpringGraniteConfig extends AbstractFrameworkGraniteConfig implements InitializingBean, ServletContextAware {

    private ServletContext servletContext = null;

    
	// Determine Spring Security version
    public static boolean isSpringSecurity3Present() {
    	try {
    		SpringGraniteConfig.class.getClassLoader().loadClass("org.springframework.security.access.AccessDeniedException");
    		return true;
    	}
    	catch (ClassNotFoundException e) {
    	}
    	return false;
    }
    public static boolean isSpringSecurity2Present() {
    	try {
    		SpringGraniteConfig.class.getClassLoader().loadClass("org.springframework.security.context.SecurityContext");
    		return true;
    	}
    	catch (ClassNotFoundException e) {
    	}
    	return false;
    }
    
    public void afterPropertiesSet() throws IOException, SAXException {
    	init(servletContext, "org/granite/spring/granite-config-spring.xml");
    	
    	if (getGraniteConfig().getSecurityService() == null) {
    		// Autodetect and configure Spring Security service
    		// Load dynamically to avoid runtime dependency on SS
    		try {
		    	if (isSpringSecurity3Present())
		    		getGraniteConfig().setSecurityService(ClassUtil.newInstance("org.granite.spring.security.SpringSecurity3Service", SecurityService.class));
		    	else if (isSpringSecurity2Present())
		    		getGraniteConfig().setSecurityService(ClassUtil.newInstance("org.granite.messaging.service.security.SpringSecurityService", SecurityService.class));
    		}
    		catch (Exception e) {
    			throw new IOException("Could not configure Spring Security service");
    		}
    	}
    }
    
    public void setServletContext(ServletContext servletContext) {
    	this.servletContext = servletContext;
    }
}
