/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.granite.config.AbstractFrameworkGraniteConfig;
import org.granite.messaging.service.security.SecurityService;
import org.granite.util.ClassUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;
import org.xml.sax.SAXException;

public class SpringGraniteConfig
extends AbstractFrameworkGraniteConfig
implements InitializingBean,
ServletContextAware {
    private ServletContext servletContext = null;

    public static boolean isSpringSecurity3Present() {
        try {
            SpringGraniteConfig.class.getClassLoader().loadClass("org.springframework.security.access.AccessDeniedException");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isSpringSecurity2Present() {
        try {
            SpringGraniteConfig.class.getClassLoader().loadClass("org.springframework.security.context.SecurityContext");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void afterPropertiesSet() throws IOException, SAXException {
        this.init(this.servletContext, "org/granite/spring/granite-config-spring.xml");
        if (this.getGraniteConfig().getSecurityService() == null) {
            try {
                if (SpringGraniteConfig.isSpringSecurity3Present()) {
                    this.getGraniteConfig().setSecurityService((SecurityService)ClassUtil.newInstance((String)"org.granite.spring.security.SpringSecurity3Service", SecurityService.class));
                } else if (SpringGraniteConfig.isSpringSecurity2Present()) {
                    this.getGraniteConfig().setSecurityService((SecurityService)ClassUtil.newInstance((String)"org.granite.messaging.service.security.SpringSecurityService", SecurityService.class));
                }
            }
            catch (Exception e) {
                throw new IOException("Could not configure Spring Security service");
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

