/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring.security;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurity3Service
extends AbstractSecurityService {
    private static final Logger log = Logger.getLogger(SpringSecurity3Service.class);
    private static final String SPRING_AUTHENTICATION_TOKEN = String.valueOf(SpringSecurity3Service.class.getName()) + ".SPRING_AUTHENTICATION_TOKEN";
    private AuthenticationManager authenticationManager = null;
    private String authenticationManagerBeanName = null;

    public SpringSecurity3Service() {
        log.debug("Starting Spring 3 Security Service!", new Object[0]);
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void configure(Map<String, String> params) {
        log.debug("Configuring with parameters %s: ", new Object[]{params});
        if (params.containsKey("authentication-manager-bean-name")) {
            this.authenticationManagerBeanName = params.get("authentication-manager-bean-name");
        }
    }

    public void login(Object credentials) {
        List<String> decodedCredentials = Arrays.asList(this.decodeBase64Credentials(credentials));
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = context.getRequest();
        String user = decodedCredentials.get(0);
        String password = decodedCredentials.get(1);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)password);
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)httpRequest.getSession().getServletContext());
        if (ctx != null) {
            this.lookupAuthenticationManager((ApplicationContext)ctx, this.authenticationManagerBeanName);
            try {
                Authentication authentication = this.authenticationManager.authenticate((Authentication)auth);
                SecurityContextHolder.getContext().setAuthentication(authentication);
                httpRequest.getSession().setAttribute(SPRING_AUTHENTICATION_TOKEN, (Object)authentication);
            }
            catch (BadCredentialsException e) {
                throw SecurityServiceException.newInvalidCredentialsException((String)e.getMessage());
            }
        }
        log.debug("Logged In!", new Object[0]);
    }

    public void lookupAuthenticationManager(ApplicationContext ctx, String authenticationManagerBeanName) throws SecurityServiceException {
        if (this.authenticationManager != null) {
            return;
        }
        Map authManagers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, AuthenticationManager.class);
        if (authenticationManagerBeanName != null) {
            this.authenticationManager = (AuthenticationManager)authManagers.get(authenticationManagerBeanName);
            if (this.authenticationManager == null) {
                log.error("AuthenticationManager bean not found " + authenticationManagerBeanName, new Object[0]);
                throw SecurityServiceException.newInvalidCredentialsException((String)"Authentication failed");
            }
            return;
        }
        if (authManagers.size() > 1) {
            log.error("More than one AuthenticationManager beans found, specify which one to use in Spring config <graniteds:security-service authentication-manager='myAuthManager'/> or in granite-config.xml <security type='org.granite.spring.security.SpringSecurity3Service'><param name='authentication-manager-bean-name' value='myAuthManager'/></security>", new Object[0]);
            throw SecurityServiceException.newInvalidCredentialsException((String)"Authentication failed");
        }
        this.authenticationManager = (AuthenticationManager)authManagers.values().iterator().next();
    }

    public Object authorize(AbstractSecurityContext context) throws Exception {
        log.debug("Authorize: %s", new Object[]{context});
        log.debug("Is %s secured? %b", new Object[]{context.getDestination().getId(), context.getDestination().isSecured()});
        this.startAuthorization(context);
        Authentication authentication = this.getAuthentication();
        if (context.getDestination().isSecured()) {
            if (!this.isAuthenticated(authentication)) {
                log.debug("Is not authenticated!", new Object[0]);
                throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
            }
            if (!this.userCanAccessService(context, authentication)) {
                log.debug("Access denied for: %s", new Object[]{authentication.getName()});
                throw SecurityServiceException.newAccessDeniedException((String)"User not in required role");
            }
        }
        if (this.isAuthenticated(authentication)) {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            securityContext.setAuthentication(authentication);
        }
        try {
            Object object = this.endAuthorization(context);
            return object;
        }
        catch (InvocationTargetException e) {
            this.handleAuthorizationExceptions(e);
            throw e;
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    public void logout() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        context.getSession().invalidate();
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
    }

    protected boolean isUserInRole(Authentication authentication, String role) {
        for (GrantedAuthority ga : authentication.getAuthorities()) {
            if (!ga.getAuthority().matches(role)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAuthenticated(Authentication authentication) {
        return authentication != null && authentication.isAuthenticated();
    }

    protected boolean userCanAccessService(AbstractSecurityContext context, Authentication authentication) {
        log.debug("Is authenticated as: %s", new Object[]{authentication.getName()});
        for (String role : context.getDestination().getRoles()) {
            if (this.isUserInRole(authentication, role)) {
                log.debug("Allowed access to %s in role %s", new Object[]{authentication.getName(), role});
                return true;
            }
            log.debug("Access denied for %s not in role %s", new Object[]{authentication.getName(), role});
        }
        return false;
    }

    protected Authentication getAuthentication() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = context.getRequest();
        Authentication authentication = (Authentication)httpRequest.getSession().getAttribute(SPRING_AUTHENTICATION_TOKEN);
        return authentication;
    }

    protected void handleAuthorizationExceptions(InvocationTargetException e) {
        Throwable t = e;
        while (t != null) {
            if (t instanceof SecurityException || t instanceof AccessDeniedException || "javax.ejb.EJBAccessException".equals(t.getClass().getName())) {
                throw SecurityServiceException.newAccessDeniedException((String)t.getMessage());
            }
            t = ((Throwable)t).getCause();
        }
    }
}

