/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.annotations.BypassTideMerge;
import org.granite.tide.data.DataContext;
import org.granite.tide.invocation.ContextUpdate;
import org.granite.tide.invocation.InvocationCall;
import org.granite.tide.invocation.InvocationResult;
import org.granite.tide.spring.SpringServiceContext;
import org.granite.util.ClassUtil;
import org.springframework.beans.TypeMismatchException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringMVCServiceContext
extends SpringServiceContext {
    private static final long serialVersionUID = 1L;
    private static final String REQUEST_VALUE = "__REQUEST_VALUE__";
    private static final Logger log = Logger.getLogger(SpringMVCServiceContext.class);
    private static final String SPRINGMVC_BINDING_ATTR = "__SPRINGMVC_LOCAL_BINDING__";

    public Object adjustInvokee(Object instance, String componentName, Set<Class<?>> componentClasses) {
        for (Class<?> componentClass : componentClasses) {
            if (!componentClass.isAnnotationPresent(org.springframework.stereotype.Controller.class)) continue;
            return new AnnotationMethodHandlerAdapter(){

                protected ServletRequestDataBinder createBinder(HttpServletRequest request, Object target, String objectName) throws Exception {
                    return new ControllerRequestDataBinder((ServletRequest)request, target, objectName);
                }
            };
        }
        if (Controller.class.isInstance(instance) || componentName.endsWith("Controller")) {
            return new SimpleControllerHandlerAdapter();
        }
        return instance;
    }

    public Object[] beforeMethodSearch(Object instance, String methodName, Object[] args) {
        if (instance instanceof HandlerAdapter) {
            boolean grails = this.getSpringContext().getClass().getName().indexOf("Grails") > 0;
            String componentName = (String)args[0];
            String componentClassName = (String)args[1];
            Class componentClass = null;
            try {
                if (componentClassName != null) {
                    componentClass = ClassUtil.forName((String)componentClassName);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException("Component class not found " + componentClassName, (Throwable)e);
            }
            Object component = this.findComponent(componentName, componentClass);
            Set<Class<?>> componentClasses = this.findComponentClasses(componentName, componentClass);
            Object handler = component;
            if (grails && componentName.endsWith("Controller")) {
                handler = this.springContext.getBean("mainSimpleController");
            }
            HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
            Map requestMap = args[3] != null && args[3] instanceof Object[] && ((Object[])args[3]).length >= 1 && ((Object[])args[3]).length <= 2 && ((Object[])args[3])[0] instanceof Map ? (Map)((Object[])args[3])[0] : null;
            boolean localBinding = false;
            if (args[3] != null && args[3] instanceof Object[] && ((Object[])args[3]).length == 2 && ((Object[])args[3])[0] instanceof Map && ((Object[])args[3])[1] instanceof Boolean) {
                localBinding = (Boolean)((Object[])args[3])[1];
            }
            context.getRequestMap().put(SPRINGMVC_BINDING_ATTR, localBinding);
            HashMap<String, Object> valueMap = null;
            if (args[4] instanceof InvocationCall) {
                valueMap = new HashMap<String, Object>();
                for (ContextUpdate contextUpdate : ((InvocationCall)args[4]).getUpdates()) {
                    valueMap.put(String.valueOf(contextUpdate.getComponentName()) + (contextUpdate.getExpression() != null ? "." + contextUpdate.getExpression() : ""), contextUpdate.getValue());
                }
            }
            if (grails) {
                try {
                    for (Class<Object> clazz : componentClasses) {
                        if (clazz.isInterface()) continue;
                        Method m = clazz.getDeclaredMethod("getProperty", String.class);
                        Map map = (Map)m.invoke(component, "params");
                        if (requestMap != null) {
                            map.putAll(requestMap);
                        }
                        if (valueMap == null) continue;
                        map.putAll(valueMap);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ControllerRequestWrapper controllerRequestWrapper = new ControllerRequestWrapper(grails, context.getRequest(), componentName, (String)args[2], requestMap, valueMap);
            return new Object[]{"handle", new Object[]{controllerRequestWrapper, context.getResponse(), handler}};
        }
        return super.beforeMethodSearch(instance, methodName, args);
    }

    @Override
    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName, Class<?> componentClass) {
        super.prepareCall(context, c, componentName, componentClass);
        if (componentName == null) {
            return;
        }
        Object component = this.findComponent(componentName, componentClass);
        if (context.getBean() instanceof HandlerAdapter) {
            ApplicationContext webContext = this.getSpringContext();
            String[] interceptorNames = webContext.getBeanNamesForType(HandlerInterceptor.class);
            String[] webRequestInterceptors = webContext.getBeanNamesForType(WebRequestInterceptor.class);
            HandlerInterceptor[] interceptors = new HandlerInterceptor[interceptorNames.length + webRequestInterceptors.length];
            int j = 0;
            int i = 0;
            while (i < webRequestInterceptors.length) {
                interceptors[j++] = new WebRequestHandlerInterceptorAdapter((WebRequestInterceptor)webContext.getBean(webRequestInterceptors[i]));
                ++i;
            }
            i = 0;
            while (i < interceptorNames.length) {
                interceptors[j++] = (HandlerInterceptor)webContext.getBean(interceptorNames[i]);
                ++i;
            }
            HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
            graniteContext.getRequestMap().put(HandlerInterceptor.class.getName(), interceptors);
            try {
                int i2 = 0;
                while (i2 < interceptors.length) {
                    HandlerInterceptor interceptor = interceptors[i2];
                    interceptor.preHandle((HttpServletRequest)context.getParameters()[0], graniteContext.getResponse(), component);
                    ++i2;
                }
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName, Class<?> componentClass) {
        DataContext dataContext;
        ArrayList<ContextUpdate> results = null;
        Object component = null;
        if (componentName != null && context.getBean() instanceof HandlerAdapter) {
            boolean grails;
            component = this.findComponent(componentName, componentClass);
            HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
            Map modelMap = null;
            if (result instanceof ModelAndView) {
                ModelAndView modelAndView = (ModelAndView)result;
                modelMap = modelAndView.getModel();
                result = modelAndView.getViewName();
                if (context.getBean() instanceof HandlerAdapter) {
                    try {
                        HandlerInterceptor[] interceptors = (HandlerInterceptor[])graniteContext.getRequestMap().get(HandlerInterceptor.class.getName());
                        if (interceptors != null) {
                            int i = interceptors.length - 1;
                            while (i >= 0) {
                                HandlerInterceptor interceptor = interceptors[i];
                                interceptor.postHandle((HttpServletRequest)context.getParameters()[0], graniteContext.getResponse(), component, modelAndView);
                                --i;
                            }
                            this.triggerAfterCompletion(component, interceptors.length - 1, interceptors, graniteContext.getRequest(), graniteContext.getResponse(), null);
                        }
                    }
                    catch (Exception e) {
                        throw new ServiceException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (modelMap != null) {
                Boolean localBinding = (Boolean)graniteContext.getRequestMap().get(SPRINGMVC_BINDING_ATTR);
                results = new ArrayList<ContextUpdate>();
                for (Map.Entry me : modelMap.entrySet()) {
                    if (me.getKey().toString().startsWith("org.springframework.validation.") || me.getValue() != null && (me.getValue().getClass().getName().startsWith("groovy.lang.ExpandoMetaClass") || me.getValue().getClass().getName().indexOf("$_closure") > 0 || me.getValue() instanceof Class)) continue;
                    String variableName = me.getKey().toString();
                    if (Boolean.TRUE.equals(localBinding)) {
                        results.add(new ContextUpdate(componentName, variableName, me.getValue(), 3, false));
                        continue;
                    }
                    results.add(new ContextUpdate(variableName, null, me.getValue(), 3, false));
                }
            }
            boolean bl = grails = this.getSpringContext().getClass().getName().indexOf("Grails") > 0;
            if (grails) {
                try {
                    Set<Class<?>> componentClasses = this.findComponentClasses(componentName, componentClass);
                    for (Class<?> cClass : componentClasses) {
                        if (cClass.isInterface()) continue;
                        Method m = cClass.getDeclaredMethod("getProperty", String.class);
                        Map map = (Map)m.invoke(component, "flash");
                        if (results == null) {
                            results = new ArrayList();
                        }
                        for (Map.Entry me : map.entrySet()) {
                            Object value = me.getValue();
                            if (value != null && value.getClass().getName().startsWith("org.codehaus.groovy.runtime.GString")) {
                                value = value.toString();
                            }
                            results.add(new ContextUpdate("flash", (String)me.getKey(), value, 3, false));
                        }
                    }
                }
                catch (Exception e) {
                    throw new ServiceException("Flash scope retrieval failed", (Throwable)e);
                }
            }
        }
        Set dataUpdates = (dataContext = DataContext.get()) != null ? dataContext.getDataUpdates() : null;
        Object[][] updates = null;
        if (dataUpdates != null && !dataUpdates.isEmpty()) {
            updates = (Object[][])dataUpdates.toArray((T[])new Object[dataUpdates.size()][]);
        }
        InvocationResult ires = new InvocationResult(result, results);
        if (component == null) {
            component = context.getBean();
        }
        if (component.getClass().isAnnotationPresent(BypassTideMerge.class)) {
            ires.setMerge(false);
        } else if (context.getParameters().length <= 0 || !(context.getParameters()[0] instanceof ControllerRequestWrapper)) {
            try {
                Method m = component.getClass().getMethod(context.getMethod().getName(), context.getMethod().getParameterTypes());
                if (m.isAnnotationPresent(BypassTideMerge.class)) {
                    ires.setMerge(false);
                }
            }
            catch (Exception e) {
                log.warn("Could not find bean method", new Object[]{e});
            }
        }
        ires.setUpdates(updates);
        return ires;
    }

    @Override
    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName, Class<?> componentClass) {
        if (componentName != null && context.getBean() instanceof HandlerAdapter) {
            HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
            Object component = this.findComponent(componentName, componentClass);
            HandlerInterceptor[] interceptors = (HandlerInterceptor[])graniteContext.getRequestMap().get(HandlerInterceptor.class.getName());
            this.triggerAfterCompletion(component, interceptors.length - 1, interceptors, graniteContext.getRequest(), graniteContext.getResponse(), t instanceof Exception ? (Exception)t : null);
        }
        super.postCallFault(context, t, componentName, componentClass);
    }

    private void triggerAfterCompletion(Object component, int interceptorIndex, HandlerInterceptor[] interceptors, HttpServletRequest request, HttpServletResponse response, Exception ex) {
        int i = interceptorIndex;
        while (i >= 0) {
            HandlerInterceptor interceptor = interceptors[i];
            try {
                interceptor.afterCompletion(request, response, component, ex);
            }
            catch (Throwable ex2) {
                log.error("HandlerInterceptor.afterCompletion threw exception", new Object[]{ex2});
            }
            --i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ControllerRequestDataBinder
    extends ServletRequestDataBinder {
        private ControllerRequestWrapper wrapper;
        private Object target;

        public ControllerRequestDataBinder(ServletRequest request, Object target, String objectName) {
            super(target, objectName);
            this.wrapper = null;
            this.target = null;
            this.wrapper = (ControllerRequestWrapper)request;
            this.target = target;
        }

        private Object getBindValue(boolean request, Class<?> requiredType) {
            Converter converter;
            Object value;
            GraniteContext context = GraniteContext.getCurrentInstance();
            TidePersistenceManager pm = SpringMVCServiceContext.this.getTidePersistenceManager(true);
            ClassGetter classGetter = context.getGraniteConfig().getClassGetter();
            Object object = value = request ? this.wrapper.getRequestValue(this.getObjectName()) : this.wrapper.getBindValue(this.getObjectName());
            if (requiredType != null && (converter = context.getGraniteConfig().getConverters().getConverter(value, requiredType)) != null) {
                value = converter.convert(value, requiredType);
            }
            if (value != null && !request) {
                return SpringMVCServiceContext.this.mergeExternal(pm, classGetter, value, null, null, null);
            }
            return value;
        }

        public void bind(ServletRequest request) {
            Object value = this.getBindValue(false, null);
            if (value != null) {
                this.target = value;
            }
        }

        public Object getTarget() {
            return this.target;
        }

        public Object convertIfNecessary(Object value, Class requiredType, MethodParameter methodParam) throws TypeMismatchException {
            if (this.target == null && value == SpringMVCServiceContext.REQUEST_VALUE || value instanceof String[] && ((String[])value)[0] == SpringMVCServiceContext.REQUEST_VALUE) {
                return this.getBindValue(true, requiredType);
            }
            return super.convertIfNecessary(value, requiredType, methodParam);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ControllerRequestWrapper
    extends HttpServletRequestWrapper {
        private String componentName;
        private String methodName;
        private Map<String, Object> requestMap;
        private Map<String, Object> valueMap;

        public ControllerRequestWrapper(boolean grails, HttpServletRequest request, String componentName, String methodName, Map<String, Object> requestMap, Map<String, Object> valueMap) {
            super(request);
            this.componentName = null;
            this.methodName = null;
            this.requestMap = null;
            this.valueMap = null;
            this.componentName = componentName.substring(0, componentName.length() - "Controller".length());
            if (this.componentName.indexOf(".") > 0) {
                this.componentName = this.componentName.substring(this.componentName.lastIndexOf(".") + 1);
            }
            if (grails) {
                this.componentName = String.valueOf(this.componentName.substring(0, 1).toLowerCase()) + this.componentName.substring(1);
            }
            this.methodName = methodName;
            this.requestMap = requestMap;
            this.valueMap = valueMap;
        }

        public String getRequestURI() {
            return String.valueOf(this.getContextPath()) + "/" + this.componentName + "/" + this.methodName;
        }

        public String getServletPath() {
            return "/" + this.componentName + "/" + this.methodName;
        }

        public Object getRequestValue(String key) {
            return this.requestMap != null ? this.requestMap.get(key) : null;
        }

        public Object getBindValue(String key) {
            return this.valueMap != null ? this.valueMap.get(key) : null;
        }

        public String getParameter(String name) {
            return this.requestMap != null && this.requestMap.containsKey(name) ? SpringMVCServiceContext.REQUEST_VALUE : null;
        }

        public String[] getParameterValues(String name) {
            String[] stringArray;
            if (this.requestMap != null && this.requestMap.containsKey(name)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = SpringMVCServiceContext.REQUEST_VALUE;
            } else {
                stringArray = null;
            }
            return stringArray;
        }

        public Map getParameterMap() {
            HashMap<String, String> pmap = new HashMap<String, String>();
            if (this.requestMap != null) {
                for (String name : this.requestMap.keySet()) {
                    pmap.put(name, SpringMVCServiceContext.REQUEST_VALUE);
                }
            }
            return pmap;
        }

        public Enumeration getParameterNames() {
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            if (this.requestMap != null) {
                ht.putAll(this.requestMap);
            }
            return ht.keys();
        }
    }
}

