/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideServiceContext;
import org.granite.tide.TideTransactionManager;
import org.granite.tide.annotations.BypassTideMerge;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.data.DataContext;
import org.granite.tide.invocation.InvocationResult;
import org.granite.tide.spring.SpringPersistenceManager;
import org.granite.tide.spring.SpringTransactionManager;
import org.granite.util.ClassUtil;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    protected transient ApplicationContext springContext = null;
    private String persistenceManagerBeanName = null;
    private String entityManagerFactoryBeanName = null;
    private static final Logger log = Logger.getLogger(SpringServiceContext.class);

    public SpringServiceContext() throws ServiceException {
        log.debug("Getting spring context from container", new Object[0]);
        this.getSpringContext();
    }

    protected ApplicationContext getSpringContext() {
        if (this.springContext == null) {
            GraniteContext context = GraniteContext.getCurrentInstance();
            ServletContext sc = ((HttpGraniteContext)context).getServletContext();
            this.springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        }
        return this.springContext;
    }

    protected AsyncPublisher getAsyncPublisher() {
        return null;
    }

    public Object findComponent(String componentName, Class<?> componentClass) {
        Object bean = null;
        String key = "__TIDE_COMPONENT__" + componentName;
        GraniteContext context = GraniteContext.getCurrentInstance();
        if (context != null && (bean = (Object)context.getRequestMap().get(key)) != null) {
            return bean;
        }
        ApplicationContext springContext = this.getSpringContext();
        try {
            if (componentClass != null) {
                Map beans = springContext.getBeansOfType(componentClass);
                if (beans.size() == 1) {
                    bean = beans.values().iterator().next();
                } else if (beans.size() > 1 && componentName != null && !"".equals(componentName)) {
                    if (beans.containsKey(componentName)) {
                        bean = beans.get(componentName);
                    }
                } else if (beans.isEmpty() && springContext.getClass().getName().indexOf("Grails") > 0 && componentClass.getName().endsWith("Service")) {
                    try {
                        Object serviceClass = springContext.getBean(String.valueOf(componentClass.getName()) + "ServiceClass");
                        Method m = serviceClass.getClass().getMethod("getPropertyName", new Class[0]);
                        String compName = (String)m.invoke(serviceClass, new Object[0]);
                        bean = springContext.getBean(compName);
                    }
                    catch (NoSuchMethodException e) {
                        log.error((Throwable)e, "Could not get service class for %s", new Object[]{componentClass.getName()});
                    }
                    catch (InvocationTargetException e) {
                        log.error(e.getCause(), "Could not get service class for %s", new Object[]{componentClass.getName()});
                    }
                    catch (IllegalAccessException e) {
                        log.error(e.getCause(), "Could not get service class for %s", new Object[]{componentClass.getName()});
                    }
                }
            }
            if (bean == null && componentName != null && !"".equals(componentName)) {
                bean = springContext.getBean(componentName);
            }
            if (context != null) {
                context.getRequestMap().put(key, bean);
            }
            return bean;
        }
        catch (NoSuchBeanDefinitionException nexc) {
            if (componentName.endsWith("Controller")) {
                try {
                    int idx = componentName.lastIndexOf(".");
                    String controllerName = idx > 0 ? String.valueOf(componentName.substring(0, idx + 1)) + componentName.substring(idx + 1, idx + 2).toUpperCase() + componentName.substring(idx + 2) : String.valueOf(componentName.substring(0, 1).toUpperCase()) + componentName.substring(1);
                    bean = this.getSpringContext().getBean(controllerName);
                    if (context != null) {
                        context.getRequestMap().put(key, bean);
                    }
                    return bean;
                }
                catch (NoSuchBeanDefinitionException idx) {
                    // empty catch block
                }
            }
            String msg = "Spring service named '" + componentName + "' does not exist.";
            ServiceException e = new ServiceException(msg, (Throwable)nexc);
            throw e;
        }
        catch (BeansException bexc) {
            String msg = "Unable to create Spring service named '" + componentName + "'";
            ServiceException e = new ServiceException(msg, (Throwable)bexc);
            throw e;
        }
    }

    public Set<Class<?>> findComponentClasses(String componentName, Class<?> componentClass) {
        String key = "__TIDE_COMPONENT_CLASS__" + componentName;
        HashSet classes = null;
        GraniteContext context = GraniteContext.getCurrentInstance();
        if (context != null && (classes = (HashSet)context.getRequestMap().get(key)) != null) {
            return classes;
        }
        try {
            Object bean = this.findComponent(componentName, componentClass);
            classes = new HashSet();
            Class<?>[] classArray = bean.getClass().getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                classes.add(i);
                ++n2;
            }
            while (bean instanceof Advised) {
                bean = ((Advised)bean).getTargetSource().getTarget();
            }
            classes.add(AopUtils.getTargetClass((Object)bean));
            if (context != null) {
                context.getRequestMap().put(key, classes);
            }
            return classes;
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Could not get class for component " + componentName, new Object[0]);
            return null;
        }
    }

    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName, Class<?> componentClass) {
    }

    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName, Class<?> componentClass) {
        List results = null;
        DataContext dataContext = DataContext.get();
        Set dataUpdates = dataContext != null ? dataContext.getDataUpdates() : null;
        Object[][] updates = null;
        if (dataUpdates != null && !dataUpdates.isEmpty()) {
            updates = (Object[][])dataUpdates.toArray((T[])new Object[dataUpdates.size()][]);
        }
        InvocationResult ires = new InvocationResult(result, results);
        if (context.getBean().getClass().isAnnotationPresent(BypassTideMerge.class)) {
            ires.setMerge(false);
        } else if (context.getMethod().isAnnotationPresent(BypassTideMerge.class)) {
            ires.setMerge(false);
        }
        ires.setUpdates(updates);
        return ires;
    }

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName, Class<?> componentClass) {
    }

    public void setEntityManagerFactoryBeanName(String beanName) {
        this.entityManagerFactoryBeanName = beanName;
    }

    public void setPersistenceManagerBeanName(String beanName) {
        this.persistenceManagerBeanName = beanName;
    }

    protected TidePersistenceManager getTidePersistenceManager(boolean create) {
        if (!create) {
            return null;
        }
        TidePersistenceManager pm = (TidePersistenceManager)GraniteContext.getCurrentInstance().getRequestMap().get(TidePersistenceManager.class.getName());
        if (pm != null) {
            return pm;
        }
        pm = this.createPersistenceManager();
        GraniteContext.getCurrentInstance().getRequestMap().put(TidePersistenceManager.class.getName(), pm);
        return pm;
    }

    private TidePersistenceManager createPersistenceManager() {
        if (this.persistenceManagerBeanName == null) {
            if (this.entityManagerFactoryBeanName == null) {
                Map pms = this.springContext.getBeansOfType(TidePersistenceManager.class);
                if (pms.size() > 1) {
                    throw new RuntimeException("More than one Tide persistence managers defined");
                }
                if (pms.size() == 1) {
                    return (TidePersistenceManager)pms.values().iterator().next();
                }
                Map tms = this.springContext.getBeansOfType(PlatformTransactionManager.class);
                if (tms.isEmpty()) {
                    log.debug("No Spring transaction manager found, specify a persistence-manager-bean-name or entity-manager-factory-bean-name", new Object[0]);
                } else if (tms.size() > 1) {
                    log.debug("More than one Spring transaction manager found, specify a persistence-manager-bean-name or entity-manager-factory-bean-name", new Object[0]);
                } else if (tms.size() == 1) {
                    PlatformTransactionManager ptm;
                    block28: {
                        ptm = (PlatformTransactionManager)tms.values().iterator().next();
                        try {
                            Class emfiClass = ClassUtil.forName((String)"org.springframework.orm.jpa.EntityManagerFactoryInfo");
                            Map emfs = this.springContext.getBeansOfType(emfiClass);
                            if (emfs.size() != 1) break block28;
                            try {
                                Constructor<?>[] cs;
                                Class emfClass = ClassUtil.forName((String)"javax.persistence.EntityManagerFactory");
                                Class pcmClass = ClassUtil.forName((String)"org.granite.tide.data.JPAPersistenceManager");
                                Constructor<?>[] constructorArray = cs = pcmClass.getConstructors();
                                int n = cs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Constructor<?> c = constructorArray[n2];
                                    if (c.getParameterTypes().length == 2 && emfClass.isAssignableFrom(c.getParameterTypes()[0]) && TideTransactionManager.class.isAssignableFrom(c.getParameterTypes()[1])) {
                                        log.debug("Created JPA persistence manager with Spring transaction manager", new Object[0]);
                                        SpringTransactionManager tm = new SpringTransactionManager(ptm);
                                        return (TidePersistenceManager)c.newInstance(((EntityManagerFactoryInfo)emfs.values().iterator().next()).getNativeEntityManagerFactory(), tm);
                                    }
                                    ++n2;
                                }
                            }
                            catch (Exception e) {
                                log.error((Throwable)e, "Could not setup persistence manager for JPA " + (String)emfs.keySet().iterator().next(), new Object[0]);
                            }
                        }
                        catch (ClassNotFoundException emfiClass) {
                        }
                        catch (NoClassDefFoundError emfiClass) {
                        }
                        catch (Exception e) {
                            log.error("Could not lookup EntityManagerFactoryInfo", new Object[]{e});
                        }
                    }
                    return new SpringPersistenceManager(ptm);
                }
            }
            String emfBeanName = this.entityManagerFactoryBeanName != null ? this.entityManagerFactoryBeanName : "entityManagerFactory";
            try {
                Object emf = this.findComponent(emfBeanName, null);
                SpringTransactionManager tm = null;
                Map ptms = this.springContext.getBeansOfType(PlatformTransactionManager.class);
                if (ptms.size() == 1) {
                    log.debug("Found Spring transaction manager " + (String)ptms.keySet().iterator().next(), new Object[0]);
                    tm = new SpringTransactionManager((PlatformTransactionManager)ptms.values().iterator().next());
                }
                Class emfClass = ClassUtil.forName((String)"javax.persistence.EntityManagerFactory");
                Class pcmClass = ClassUtil.forName((String)"org.granite.tide.data.JPAPersistenceManager");
                Constructor<?>[] cs = pcmClass.getConstructors();
                if (tm != null) {
                    Constructor<?>[] constructorArray = cs;
                    int n = cs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Constructor<?> c = constructorArray[n3];
                        if (c.getParameterTypes().length == 2 && emfClass.isAssignableFrom(c.getParameterTypes()[0]) && TideTransactionManager.class.isAssignableFrom(c.getParameterTypes()[1])) {
                            log.debug("Created JPA persistence manager with Spring transaction manager", new Object[0]);
                            return (TidePersistenceManager)c.newInstance(((EntityManagerFactoryInfo)emf).getNativeEntityManagerFactory(), tm);
                        }
                        ++n3;
                    }
                } else {
                    Constructor<?>[] constructorArray = cs;
                    int n = cs.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Constructor<?> c = constructorArray[n4];
                        if (c.getParameterTypes().length == 1 && emfClass.isAssignableFrom(c.getParameterTypes()[0])) {
                            log.debug("Created default JPA persistence manager", new Object[0]);
                            return (TidePersistenceManager)c.newInstance(emf);
                        }
                        ++n4;
                    }
                }
                throw new RuntimeException("Default Tide persistence manager not found");
            }
            catch (ServiceException e) {
                if (this.entityManagerFactoryBeanName != null) {
                    log.debug("EntityManagerFactory named %s not found, JPA support disabled", new Object[]{emfBeanName});
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create default Tide persistence manager", e);
            }
        }
        return (TidePersistenceManager)this.findComponent(this.persistenceManagerBeanName, null);
    }
}

