/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.granite.tide.annotations.TideEnabled;
import org.granite.tide.spring.security.Identity;
import org.springframework.security.Authentication;
import org.springframework.security.acls.Acl;
import org.springframework.security.acls.AclService;
import org.springframework.security.acls.NotFoundException;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.domain.DefaultPermissionFactory;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.objectidentity.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.sid.Sid;
import org.springframework.security.acls.sid.SidRetrievalStrategy;
import org.springframework.security.acls.sid.SidRetrievalStrategyImpl;
import org.springframework.security.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TideEnabled
public class AclIdentity
extends Identity {
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    private AclService aclService = null;

    public void setSidRetrievalStrategy(SidRetrievalStrategy strategy) {
        this.sidRetrievalStrategy = strategy;
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy strategy) {
        this.objectIdentityRetrievalStrategy = strategy;
    }

    public void setAclService(AclService aclService) {
        this.aclService = aclService;
    }

    public boolean hasPermission(Object entity, String permissions) {
        if (entity == null) {
            return true;
        }
        List<Permission> requiredPermissions = null;
        try {
            requiredPermissions = this.parsePermissionsString(permissions);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        Sid[] sids = this.sidRetrievalStrategy.getSids(authentication);
        ObjectIdentity oid = this.objectIdentityRetrievalStrategy.getObjectIdentity(entity);
        try {
            Acl acl = this.aclService.readAclById(oid, sids);
            return acl.isGranted(requiredPermissions.toArray(new Permission[requiredPermissions.size()]), sids, false);
        }
        catch (NotFoundException nfe) {
            return false;
        }
    }

    private List<Permission> parsePermissionsString(String integersString) throws NumberFormatException {
        HashSet<Permission> permissions = new HashSet<Permission>();
        StringTokenizer tokenizer = new StringTokenizer(integersString, ",", false);
        DefaultPermissionFactory pf = new DefaultPermissionFactory();
        while (tokenizer.hasMoreTokens()) {
            String integer = tokenizer.nextToken();
            permissions.add(pf.buildFromMask(new Integer(integer).intValue()));
        }
        return new ArrayList<Permission>(permissions);
    }
}

