/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import org.granite.messaging.service.security.AbstractSecurityContext;
import org.springframework.security.intercept.AbstractSecurityInterceptor;
import org.springframework.security.intercept.InterceptorStatusToken;
import org.springframework.security.intercept.ObjectDefinitionSource;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.FilterInvocationDefinitionSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpringSecurityInterceptor
extends AbstractSecurityInterceptor {
    private FilterInvocationDefinitionSource objectDefinitionSource;

    public Class<? extends Object> getSecureObjectClass() {
        return FilterInvocation.class;
    }

    public ObjectDefinitionSource obtainObjectDefinitionSource() {
        return this.objectDefinitionSource;
    }

    public void setObjectDefinitionSource(FilterInvocationDefinitionSource newSource) {
        this.objectDefinitionSource = newSource;
    }

    public Object invoke(AbstractSecurityContext securityContext) throws Exception {
        FilterInvocation fi = this.buildFilterInvocation(securityContext);
        InterceptorStatusToken token = this.beforeInvocation(fi);
        Object returnedObject = null;
        try {
            returnedObject = securityContext.invoke();
        }
        finally {
            returnedObject = this.afterInvocation(token, returnedObject);
        }
        return returnedObject;
    }

    protected abstract FilterInvocation buildFilterInvocation(AbstractSecurityContext var1);
}

