/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring.security;

import org.granite.spring.SpringGraniteConfig;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SecurityServiceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String sessionAuthenticationStrategy;
        String authenticationTrustResolver;
        String securityInterceptor;
        String securityMetadataSource;
        if (!SpringGraniteConfig.isSpringSecurity3Present()) {
            throw new RuntimeException("Cannot use graniteds:security-service with Spring 2.x");
        }
        if (!StringUtils.hasText((String)element.getAttribute("id"))) {
            element.setAttribute("id", "org.granite.spring.security.SpringSecurity3Service");
        }
        builder.setRole(2);
        String authenticationManager = element.getAttribute("authentication-manager");
        if (authenticationManager != null && authenticationManager.trim().length() > 0) {
            builder.addPropertyReference("authenticationManager", authenticationManager);
        }
        boolean allowAnonymousAccess = element.hasAttribute("allow-anonymous-access");
        builder.addPropertyValue("allowAnonymousAccess", (Object)allowAnonymousAccess);
        String securityContextRepository = element.getAttribute("security-context-repository");
        if (securityContextRepository != null && securityContextRepository.trim().length() > 0) {
            builder.addPropertyReference("securityContextRepository", securityContextRepository);
        }
        if ((securityMetadataSource = element.getAttribute("security-metadata-source")) != null && securityMetadataSource.trim().length() > 0) {
            builder.addPropertyReference("securityMetadataSource", securityMetadataSource);
        }
        if ((securityInterceptor = element.getAttribute("security-interceptor")) != null && securityInterceptor.trim().length() > 0) {
            builder.addPropertyReference("securityInterceptor", securityInterceptor);
        }
        if ((authenticationTrustResolver = element.getAttribute("authentication-trust-resolver")) != null && authenticationTrustResolver.trim().length() > 0) {
            builder.addPropertyReference("authenticationTrustResolver", authenticationTrustResolver);
        }
        if ((sessionAuthenticationStrategy = element.getAttribute("session-authentication-strategy")) != null && sessionAuthenticationStrategy.trim().length() > 0) {
            builder.addPropertyReference("sessionAuthenticationStrategy", sessionAuthenticationStrategy);
        }
    }

    protected String getBeanClassName(Element element) {
        return "org.granite.spring.security.SpringSecurity3Service";
    }
}

