/*
 * Decompiled with CFR 0.152.
 */
package org.granite.spring.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.spring.security.AbstractSpringSecurity3Interceptor;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurity3Service
extends AbstractSecurityService {
    private static final Logger log = Logger.getLogger(SpringSecurity3Service.class);
    private static final String FILTER_APPLIED = "__spring_security_scpf_applied";
    private static final String SECURITY_SERVICE_APPLIED = "__spring_security_granite_service_applied";
    private AuthenticationManager authenticationManager = null;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private SecurityContextRepository securityContextRepository = new HttpSessionSecurityContextRepository();
    private AbstractSpringSecurity3Interceptor securityInterceptor = null;
    private SessionAuthenticationStrategy sessionAuthenticationStrategy = new SessionFixationProtectionStrategy();
    private PasswordEncoder passwordEncoder = null;
    private String authenticationManagerBeanName = null;
    private boolean allowAnonymousAccess = false;
    private Method getRequest = null;
    private Method getResponse = null;

    public SpringSecurity3Service() {
        log.debug("Starting Spring 3 Security Service", new Object[0]);
        try {
            this.getRequest = HttpRequestResponseHolder.class.getDeclaredMethod("getRequest", new Class[0]);
            this.getRequest.setAccessible(true);
            this.getResponse = HttpRequestResponseHolder.class.getDeclaredMethod("getResponse", new Class[0]);
            this.getResponse.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get methods from HttpRequestResponseHolder", e);
        }
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver authenticationTrustResolver) {
        this.authenticationTrustResolver = authenticationTrustResolver;
    }

    public void setAllowAnonymousAccess(boolean allowAnonymousAccess) {
        this.allowAnonymousAccess = allowAnonymousAccess;
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        this.securityContextRepository = securityContextRepository;
    }

    public void setSecurityInterceptor(AbstractSpringSecurity3Interceptor securityInterceptor) {
        this.securityInterceptor = securityInterceptor;
    }

    public void setSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        if (sessionAuthenticationStrategy == null) {
            throw new NullPointerException("SessionAuthenticationStrategy cannot be null");
        }
        this.sessionAuthenticationStrategy = sessionAuthenticationStrategy;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void configure(Map<String, String> params) {
        log.debug("Configuring with parameters %s: ", new Object[]{params});
        if (params.containsKey("authentication-manager-bean-name")) {
            this.authenticationManagerBeanName = params.get("authentication-manager-bean-name");
        }
        if (Boolean.TRUE.toString().equals(params.get("allow-anonymous-access"))) {
            this.allowAnonymousAccess = true;
        }
    }

    public void login(Object credentials, String charset) {
        List<String> decodedCredentials = Arrays.asList(this.decodeBase64Credentials(credentials, charset));
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        String user = decodedCredentials.get(0);
        String password = decodedCredentials.get(1);
        if (this.passwordEncoder != null) {
            password = this.passwordEncoder.encodePassword(password, null);
        }
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)password);
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)httpRequest.getSession().getServletContext());
        if (ctx != null) {
            this.lookupAuthenticationManager((ApplicationContext)ctx, this.authenticationManagerBeanName);
            try {
                Authentication authentication = this.authenticationManager.authenticate((Authentication)auth);
                if (authentication != null && !this.authenticationTrustResolver.isAnonymous(authentication)) {
                    try {
                        this.sessionAuthenticationStrategy.onAuthentication(authentication, httpRequest, graniteContext.getResponse());
                    }
                    catch (SessionAuthenticationException e) {
                        log.debug((Throwable)e, "SessionAuthenticationStrategy rejected the authentication object", new Object[0]);
                        SecurityContextHolder.clearContext();
                        this.handleAuthenticationExceptions((AuthenticationException)((Object)e));
                        return;
                    }
                }
                HttpRequestResponseHolder holder = new HttpRequestResponseHolder(graniteContext.getRequest(), graniteContext.getResponse());
                SecurityContext securityContext = this.securityContextRepository.loadContext(holder);
                securityContext.setAuthentication(authentication);
                SecurityContextHolder.setContext((SecurityContext)securityContext);
                try {
                    this.securityContextRepository.saveContext(securityContext, (HttpServletRequest)this.getRequest.invoke((Object)holder, new Object[0]), (HttpServletResponse)this.getResponse.invoke((Object)holder, new Object[0]));
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Could not save context after authentication", new Object[0]);
                }
                this.endLogin(credentials, charset);
            }
            catch (AuthenticationException e) {
                this.handleAuthenticationExceptions(e);
            }
        }
        log.debug("User %s logged in", new Object[]{user});
    }

    protected void handleAuthenticationExceptions(AuthenticationException e) {
        if (e instanceof BadCredentialsException || e instanceof UsernameNotFoundException) {
            throw SecurityServiceException.newInvalidCredentialsException((String)e.getMessage());
        }
        throw SecurityServiceException.newAuthenticationFailedException((String)e.getMessage());
    }

    public void lookupAuthenticationManager(ApplicationContext ctx, String authenticationManagerBeanName) throws SecurityServiceException {
        if (this.authenticationManager != null) {
            return;
        }
        Map authManagers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, AuthenticationManager.class);
        if (authenticationManagerBeanName != null) {
            this.authenticationManager = (AuthenticationManager)authManagers.get(authenticationManagerBeanName);
            if (this.authenticationManager == null) {
                log.error("AuthenticationManager bean not found " + authenticationManagerBeanName, new Object[0]);
                throw SecurityServiceException.newAuthenticationFailedException((String)"Authentication failed");
            }
            return;
        }
        if (authManagers.size() > 1) {
            log.error("More than one AuthenticationManager beans found, specify which one to use in Spring config <graniteds:security-service authentication-manager='myAuthManager'/> or in granite-config.xml <security type='org.granite.spring.security.SpringSecurity3Service'><param name='authentication-manager-bean-name' value='myAuthManager'/></security>", new Object[0]);
            throw SecurityServiceException.newAuthenticationFailedException((String)"Authentication failed");
        }
        this.authenticationManager = (AuthenticationManager)authManagers.values().iterator().next();
    }

    public Object authorize(AbstractSecurityContext context) throws Exception {
        log.debug("Authorize %s on destination %s (secured: %b)", new Object[]{context, context.getDestination().getId(), context.getDestination().isSecured()});
        this.startAuthorization(context);
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        HttpRequestResponseHolder holder = null;
        if (graniteContext.getRequest().getAttribute(FILTER_APPLIED) == null) {
            if (graniteContext.getRequest().getAttribute(SECURITY_SERVICE_APPLIED) == null) {
                holder = new HttpRequestResponseHolder(graniteContext.getRequest(), graniteContext.getResponse());
                SecurityContext contextBeforeChainExecution = this.securityContextRepository.loadContext(holder);
                SecurityContextHolder.setContext((SecurityContext)contextBeforeChainExecution);
                if (this.isAuthenticated(authentication)) {
                    contextBeforeChainExecution.setAuthentication(authentication);
                } else {
                    authentication = contextBeforeChainExecution.getAuthentication();
                }
                graniteContext.getRequest().setAttribute(SECURITY_SERVICE_APPLIED, (Object)0);
            } else {
                graniteContext.getRequest().setAttribute(SECURITY_SERVICE_APPLIED, (Object)((Integer)graniteContext.getRequest().getAttribute(SECURITY_SERVICE_APPLIED) + 1));
            }
        }
        if (context.getDestination().isSecured()) {
            if (!this.isAuthenticated(authentication) || !this.allowAnonymousAccess && authentication instanceof AnonymousAuthenticationToken) {
                log.debug("User not authenticated!", new Object[0]);
                throw SecurityServiceException.newNotLoggedInException((String)"User not logged in");
            }
            if (!this.userCanAccessService(context, authentication)) {
                log.debug("Access denied for user %s", new Object[]{authentication.getName()});
                throw SecurityServiceException.newAccessDeniedException((String)"User not in required role");
            }
        }
        try {
            Object returnedObject;
            Object object = returnedObject = this.securityInterceptor != null ? this.securityInterceptor.invoke(context) : this.endAuthorization(context);
            return object;
        }
        catch (AccessDeniedException e) {
            throw SecurityServiceException.newAccessDeniedException((String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.handleAuthorizationExceptions(e);
            throw e;
        }
        finally {
            if (graniteContext.getRequest().getAttribute(FILTER_APPLIED) == null) {
                if ((Integer)graniteContext.getRequest().getAttribute(SECURITY_SERVICE_APPLIED) == 0) {
                    SecurityContext contextAfterChainExecution = SecurityContextHolder.getContext();
                    SecurityContextHolder.clearContext();
                    try {
                        this.securityContextRepository.saveContext(contextAfterChainExecution, (HttpServletRequest)this.getRequest.invoke((Object)holder, new Object[0]), (HttpServletResponse)this.getResponse.invoke((Object)holder, new Object[0]));
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, "Could not extract wrapped context from holder", new Object[0]);
                    }
                    graniteContext.getRequest().removeAttribute(SECURITY_SERVICE_APPLIED);
                } else {
                    graniteContext.getRequest().setAttribute(SECURITY_SERVICE_APPLIED, (Object)((Integer)graniteContext.getRequest().getAttribute(SECURITY_SERVICE_APPLIED) - 1));
                }
            }
        }
    }

    public void logout() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpSession session = context.getSession(false);
        if (session != null && this.securityContextRepository.containsContext(context.getRequest())) {
            session.invalidate();
        }
        SecurityContextHolder.clearContext();
    }

    protected boolean isUserInRole(Authentication authentication, String role) {
        for (GrantedAuthority ga : authentication.getAuthorities()) {
            if (!ga.getAuthority().matches(role)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAuthenticated(Authentication authentication) {
        return authentication != null && authentication.isAuthenticated();
    }

    protected boolean userCanAccessService(AbstractSecurityContext context, Authentication authentication) {
        log.debug("Is authenticated as: %s", new Object[]{authentication.getName()});
        for (String role : context.getDestination().getRoles()) {
            if (this.isUserInRole(authentication, role)) {
                log.debug("Allowed access to %s in role %s", new Object[]{authentication.getName(), role});
                return true;
            }
            log.debug("Access denied for %s not in role %s", new Object[]{authentication.getName(), role});
        }
        return false;
    }

    protected void handleAuthorizationExceptions(InvocationTargetException e) {
        Throwable t = e;
        while (t != null) {
            if (t instanceof SecurityException || t instanceof AccessDeniedException || "javax.ejb.EJBAccessException".equals(t.getClass().getName())) {
                throw SecurityServiceException.newAccessDeniedException((String)t.getMessage());
            }
            t = ((Throwable)t).getCause();
        }
    }
}

