/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.spring.TideDataPublishingInterceptor;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.aop.support.annotation.AnnotationClassFilter;

public class TideDataPublishingAdvisor
extends AbstractPointcutAdvisor {
    private static final long serialVersionUID = 1L;
    private TideDataPublishingInterceptor dataPublishingInterceptor;
    private final TideDataPublishingPointcut pointcut = new TideDataPublishingPointcut();

    public TideDataPublishingAdvisor() {
        this.pointcut.setClassFilter((ClassFilter)new AnnotationClassFilter(DataEnabled.class));
    }

    public TideDataPublishingAdvisor(TideDataPublishingInterceptor interceptor) {
        this.setDataPublishingInterceptor(interceptor);
    }

    public void setDataPublishingInterceptor(TideDataPublishingInterceptor interceptor) {
        this.dataPublishingInterceptor = interceptor;
    }

    public Advice getAdvice() {
        return this.dataPublishingInterceptor;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TideDataPublishingPointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private TideDataPublishingPointcut() {
        }

        public boolean matches(Method method, Class<?> targetClass) {
            return targetClass.isAnnotationPresent(DataEnabled.class) && targetClass.getAnnotation(DataEnabled.class).useInterceptor();
        }
    }
}

