/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.granite.gravity.Gravity;
import org.granite.logging.Logger;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.DataUpdatePostprocessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
public class TideDataPublishingAspect
implements Ordered {
    private static final Logger log = Logger.getLogger(TideDataPublishingAspect.class);
    private int order = 0;
    private Gravity gravity;
    private DataUpdatePostprocessor dataUpdatePostprocessor;

    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    @Autowired(required=false)
    public void setDataUpdatePostprocessor(DataUpdatePostprocessor dataUpdatePostprocessor) {
        this.dataUpdatePostprocessor = dataUpdatePostprocessor;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Around(value="@within(dataEnabled)")
    public Object invoke(ProceedingJoinPoint pjp, DataEnabled dataEnabled) throws Throwable {
        if (dataEnabled == null || !dataEnabled.useInterceptor()) {
            return pjp.proceed();
        }
        boolean shouldRemoveContextAtEnd = DataContext.get() == null;
        boolean shouldInitContext = shouldRemoveContextAtEnd || DataContext.isNull();
        boolean onCommit = false;
        if (shouldInitContext) {
            DataContext.init((Gravity)this.gravity, (String)dataEnabled.topic(), (Class)dataEnabled.params(), (DataEnabled.PublishMode)dataEnabled.publish());
            if (this.dataUpdatePostprocessor != null) {
                DataContext.get().setDataUpdatePostprocessor(this.dataUpdatePostprocessor);
            }
        }
        DataContext.observe();
        try {
            if (dataEnabled.publish().equals((Object)DataEnabled.PublishMode.ON_COMMIT) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new DataPublishingTransactionSynchronization(shouldRemoveContextAtEnd));
                    onCommit = true;
                } else {
                    log.warn("Could not register synchronization for ON_COMMIT publish mode, check that the Spring PlatformTransactionManager supports it", new Object[0]);
                }
            }
            Object ret = pjp.proceed();
            DataContext.publish((DataEnabled.PublishMode)DataEnabled.PublishMode.ON_SUCCESS);
            Object object = ret;
            return object;
        }
        finally {
            if (shouldRemoveContextAtEnd && !onCommit) {
                DataContext.remove();
            }
        }
    }

    private static class DataPublishingTransactionSynchronization
    extends TransactionSynchronizationAdapter {
        private boolean removeContext = false;

        public DataPublishingTransactionSynchronization(boolean removeContext) {
            this.removeContext = removeContext;
        }

        public void beforeCommit(boolean readOnly) {
            if (!readOnly) {
                DataContext.publish((DataEnabled.PublishMode)DataEnabled.PublishMode.ON_COMMIT);
            }
        }

        public void beforeCompletion() {
            if (this.removeContext) {
                DataContext.remove();
            }
        }
    }
}

