/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.spring;

import org.granite.tide.data.DataContext;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.TideSynchronizationManager;
import org.hibernate.Session;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.SessionImpl;
import org.springframework.orm.hibernate4.SessionHolder;

public class Hibernate4SynchronizationManager
implements TideSynchronizationManager {
    public boolean registerSynchronization(Object resource, boolean shouldRemoveContextAtEnd) {
        Session session = null;
        if (resource instanceof Session) {
            session = (Session)resource;
        } else if (resource instanceof SessionHolder) {
            session = ((SessionHolder)resource).getSession();
        } else {
            throw new IllegalArgumentException("Unknow resource for registering synchronization " + resource);
        }
        ((SessionImpl)session).getActionQueue().registerProcess((BeforeTransactionCompletionProcess)new HibernateDataPublishingProcess(shouldRemoveContextAtEnd));
        return true;
    }

    private static class HibernateDataPublishingProcess
    implements BeforeTransactionCompletionProcess {
        private boolean removeContext;

        public HibernateDataPublishingProcess(boolean removeContext) {
            this.removeContext = removeContext;
        }

        public void doBeforeTransactionCompletion(SessionImplementor session) {
            DataContext.publish((DataEnabled.PublishMode)DataEnabled.PublishMode.ON_COMMIT);
            if (this.removeContext) {
                DataContext.remove();
            }
        }
    }
}

